<?php
class Holo6PWA {
    private $racine_sys_holo6 = null;
    private $dossier_holo6_js = null;
    private $mode_client_mini = false;
    private $mode_custom_element = false;
    public $nonce_scripts = null;

    public function __construct($mode_client_mini=false) {
        $this->racine_sys_holo6 = realpath(__DIR__ . "/../");
        $this->nonce_scripts = substr(md5(mt_rand()), 0, 12);
        // $this->dossier_holo6_js = $mode_client_mini ? "holo6_js-mini" : "holo6_js";
        $this->dossier_holo6_js = "holo6_js";
        if (file_exists($this->racine_sys_holo6 . "/" . $this->dossier_holo6_js . "/holo6-mini.js")) {
          if ($mode_client_mini === null) {
            $this->mode_client_mini = (isset($_GET["h6_pwa_mini"]) ? ($_GET["h6_pwa_mini"] != 0) : false);
          }
          else {
            $this->mode_client_mini = ($mode_client_mini != 0);
          }
        }
        else {
          $this->mode_client_mini = false;
        }
    }

    public function TitrePage() {
        return "Holo6 - " . $_SERVER["SERVER_NAME"];
    }

    public function DescriptionPage() {
        return "Holo6 AI chatbot for " . $_SERVER["SERVER_NAME"];
    }

    public function RacineSysteme() {
        return $this->racine_sys_holo6;
    }

    public function SiteURL() {
        $protocol = (!empty($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] !== "off" || $_SERVER["SERVER_PORT"] == 443) ? "https://" : "http://";
        return $protocol . $_SERVER["SERVER_NAME"];
    }

    public function URL_PWA_ROOT() {
        $script_name = dirname($_SERVER["SCRIPT_NAME"]);
        if ($script_name === "/") {
            return $this->SiteURL() . "/";
        }
        else {
            return $this->SiteURL() . $script_name . "/";
        }
    }

    public function URL_Racine() {
        return dirname($this->URL_PWA_ROOT()) . "/";
    }

    public function URL_Holo6_js() {
        return $this->URL_Racine() . $this->dossier_holo6_js . "/";
    }

    public function modeClientMini() {
      return $this->mode_client_mini;
    }

    public function modeCustomElement() {
      return $this->mode_custom_element;
    }

    public function NomScriptJS() {
      return $this->mode_client_mini ? "holo6-mini.js" : "holo6.js";
    }

    public function NomCSS() {
      // return $this->mode_client_mini ? "holo6-mini.css" : "holo6.css";
      return $this->mode_client_mini ? "" : "holo6.css";
    }

    public function idHTML_CE() {
      return $this->mode_client_mini ? "holo6-mini" : "holo6-app";
    }

    public function idHTML() {
      return $this->mode_client_mini ? "holo6-ui-mini" : "holo6-ui";
    }

    public function select_prefered_language($available_languages, $http_accept_language="auto") {
        if ($http_accept_language == "auto") {
            $http_accept_language = isset($_SERVER["HTTP_ACCEPT_LANGUAGE"]) ? $_SERVER["HTTP_ACCEPT_LANGUAGE"] : "";
        }
        preg_match_all("/([[:alpha:]]{1,8})(-([[:alpha:]|-]{1,8}))?(\s*;\s*q\s*=\s*(1\.0{0,3}|0\.\d{0,3}))?\s*(,|$)/i", $http_accept_language, $hits, PREG_SET_ORDER);
        $bestlang = $available_languages[0];
        $bestqval = 0;

        foreach ($hits as $arr) {
            $langprefix = strtolower ($arr[1]);
            if (!empty($arr[3])) {
                $langrange = strtolower ($arr[3]);
                $language = $langprefix . "-" . $langrange;
            }
            else { $language = $langprefix; }
            $qvalue = 1.0;
            if (!empty($arr[5])) { $qvalue = floatval($arr[5]); }

            if (in_array($language,$available_languages) && ($qvalue > $bestqval)) {
                $bestlang = $language;
                $bestqval = $qvalue;
            }
            else if (in_array($langprefix,$available_languages) && (($qvalue*0.9) > $bestqval)) {
                $bestlang = $langprefix;
                $bestqval = $qvalue*0.9;
            }
        }
        return $bestlang;
    }

    public function URL_Manifest() {
        $lang = $this->select_prefered_language(["en", "fr"], "auto");
        $params_manifest = (isset($_GET["h6_pwa_mini"]) && ($_GET["h6_pwa_mini"] != 0)) ? "?h6_pwa_mini=1" : "";
        return $this->URL_PWA_ROOT() . "manifest." . $lang . ".json.php" . $params_manifest;
    }

    public function holo6_pwa_format_mtime_file($filename) {
        if (strlen($filename) > 0) {
            $racine = $this->racine_sys_holo6 . "/" . $this->dossier_holo6_js  . "/";
            $chemin_fichier = $racine . $filename;
            if (file_exists($chemin_fichier)) {
                return date("dmy-Gis", filemtime($chemin_fichier));
            }
        }
        return -1;
    }

    function holo6_config_json_path() {
        $nom_fichier_json = "Holo6Config-public.json";
        // $liste_dossiers_config = $this->mode_client_mini ? [ "config/1", "1" ] : [ "uploads/1", "1" ];
        $liste_dossiers_config = [ "uploads/1", "1" ];
        $nc = count($liste_dossiers_config);
        $racine_config = $this->racine_sys_holo6 . "/" . $this->dossier_holo6_js . "/";
        for ($it = 0; $it < $nc; $it++) {
            $chemin_rel = "config/" . $liste_dossiers_config[$it] . "/" . $nom_fichier_json;
            if (file_exists($racine_config . $chemin_rel)) {
                return $chemin_rel . "?ver=" . $this->holo6_pwa_format_mtime_file($chemin_rel);
            }
        }
        return "config/" . $nom_fichier_json . "?ver=" . $this->holo6_pwa_format_mtime_file($json_path);
    }
}
$INSTANCE_PWA = new Holo6PWA(false);
?>
<!DOCTYPE html>
<html style="overscroll-behavior-y: contain;">
<head>
  <meta charset="UTF-8">
  <meta http-equiv="Content-Security-Policy" content="default-src 'self'; script-src 'nonce-<?php echo($INSTANCE_PWA->nonce_scripts); ?>' 'strict-dynamic'; style-src 'self' 'unsafe-inline'; img-src 'self' data:; connect-src 'self' https://*.holo6.com; media-src 'self' https://*.holo6.com blob:;">
  <meta name="author" content="Holo6" />
  <meta name="application-name" content="Holo6" />
  <meta name="description" content="<?php echo($INSTANCE_PWA->TitrePage()); ?>" />
  <meta name="keywords" content="Holo6, IA, artificial intelligence, chatbot, assistant, custom AI assistant, qa, questions, answers, llm" />
  <meta name="robots" content="index,nofollow" />
  <meta name="color-scheme" content="light dark" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
  <link rel="canonical" href="<?php echo($INSTANCE_PWA->URL_PWA_ROOT()); ?>" />
  <link rel="manifest" href="<?php echo($INSTANCE_PWA->URL_Manifest()); ?>" />
  <link rel="search" type="application/opensearchdescription+xml" title="<?php echo($INSTANCE_PWA->TitrePage()); ?>" href="<?php echo($INSTANCE_PWA->URL_Racine()); ?>OpenSearch.xml.php" />
  <link rel="icon" type="image/png" href="<?php echo($INSTANCE_PWA->URL_PWA_ROOT()); ?>favicon-64x64.png" />
  <meta property="og:type" content="website" />
  <meta property="og:title" content="<?php echo($INSTANCE_PWA->TitrePage()); ?>" />
  <meta property="og:url" content="<?php echo($INSTANCE_PWA->URL_PWA_ROOT()); ?>" />
  <meta property="og:description" content="<?php echo($INSTANCE_PWA->DescriptionPage()); ?>" />
<?php
  $mtime_css = $INSTANCE_PWA->holo6_pwa_format_mtime_file($INSTANCE_PWA->NomCSS());
  if ($mtime_css > 0) {
    echo("  <link rel=\"stylesheet\" id=\"holo6_ui_style-css\" type=\"text/css\" href=\"" . $INSTANCE_PWA->URL_Holo6_js() . $INSTANCE_PWA->NomCSS() . "?ver=$mtime_css\" media=\"all\" />" . PHP_EOL);
  }
?>
  <title><?php echo($INSTANCE_PWA->TitrePage()); ?></title>
  <script nonce="<?php echo($INSTANCE_PWA->nonce_scripts); ?>">
    function HotLoadHolo6UI(custom_element=true) {
      const configuration_inline = (CSS.supports("height: 100dvh")) ?
        "base64://eyJhcHBzIjp7InVpIjp7IndpbmRvd19kb2NrYWJsZSI6ZmFsc2UsInNob3dfbWVzc2FnZXNfbGlzdCI6MiwiZnVsbF93aW5kb3dfc3RhdGUiOnsic2l6ZSI6eyJoZWlnaHQiOiJjYWxjKDEwMGR2aCAtIDhweCkifX19fX0=":
        "base64://eyJhcHBzIjp7InVpIjp7IndpbmRvd19kb2NrYWJsZSI6ZmFsc2UsInNob3dfbWVzc2FnZXNfbGlzdCI6MiwiZnVsbF93aW5kb3dfc3RhdGUiOnsic2l6ZSI6eyJoZWlnaHQiOiJjYWxjKDEwMHZoIC0gOHB4KSJ9fX19fQ==";
      const conteneur = document.getElementById("h6-pwa-container");
      if (conteneur) {
        const attr_prefix = custom_element ? "" : "data-";
        let app_element = (custom_element) ? document.createElement("<?php echo($INSTANCE_PWA->idHTML_CE()); ?>") : document.createElement("div");
        if (custom_element) { <?php if (!$INSTANCE_PWA->modeClientMini()) { echo("app_element.setAttribute(\"app_mode\", \"ui\");"); } ?> }
        else { app_element.setAttribute("id", "<?php echo($INSTANCE_PWA->idHTML()); ?>"); }
        <?php if (!$INSTANCE_PWA->modeClientMini()) { echo("app_element.setAttribute(attr_prefix + \"avatar_url\", \"avatars/base/avatar.json\")"); } else { echo("// Ignore attribute: avatar_url"); } ?>;
        app_element.setAttribute(attr_prefix + "configuration_file", "<?php echo($INSTANCE_PWA->holo6_config_json_path()); ?>");
        app_element.setAttribute(attr_prefix + "configuration_inline", configuration_inline);
        conteneur.appendChild(app_element);
        let n_script = document.createElement("script");
        n_script.setAttribute("src", "<?php echo($INSTANCE_PWA->URL_Holo6_js() . $INSTANCE_PWA->NomScriptJS()); ?>?ver=<?php echo($INSTANCE_PWA->holo6_pwa_format_mtime_file($INSTANCE_PWA->NomScriptJS())); ?>");
        n_script.setAttribute("type", "module");
        document.head.appendChild(n_script);
      }
    }
    function MainJS() {
      HotLoadHolo6UI(<?php echo($INSTANCE_PWA->modeCustomElement() ? "true" : "false"); ?>);
    }
    document.onreadystatechange = () => { if (document.readyState === "complete") { MainJS(); } }
  </script>
  <style>
    body { padding: 0; margin: 0; background-color: #1c1b22; }
    div { padding: 0; }
    /* :root {} */
  </style>
</head>
<body style="overscroll-behavior-y: contain;">
  <div style="display: inline-block; position: relative; width: 100%; top: 0px; font-family: Roboto, Helvetica, Arial, sans-serif;">
    <div id="h6-pwa-container" style="min-height: 10em; max-width: 297mm; margin: 0 auto; padding: 0;<?php if ($INSTANCE_PWA->modeClientMini()) { echo(" height: 100%;"); } ?>"></div>
  </div>
</body>
</html>
