<?php /* Gère l"envoi et le stockage des fichiers de configuration (version Prestashop). */


$CHEMIN_RACINE_PRESTASHOP = realpath(dirname(__FILE__) . "/../../../../../");
require_once($CHEMIN_RACINE_PRESTASHOP . "/config/config.inc.php");
require_once($CHEMIN_RACINE_PRESTASHOP . "/init.php");
include "holo6_config_upload_mod.php";


function Holo6ControleAuth() {
    if (isset($_SERVER["HTTP_X_CSRF_TOKEN"])) {  // Envoyé par le client de configuration si la variable csrf_token lui a été assigné.
        $CSRF_TOKEN = $_SERVER["HTTP_X_CSRF_TOKEN"];
        $instance_module = Module::getInstanceByName("holo6ps");
        if ($instance_module) {
            $last_session_token = Configuration::get("HOLO6_LAST_SESSION_TOKEN");
            if (is_string($last_session_token) && (strlen($last_session_token) > 0) && ($last_session_token === $CSRF_TOKEN)) {  // Validation du jeton de session...
                return true;
            }
        }
    }
    return false;
}


function Holo6ConfigEventsCallback($event_type_str, $file_path, $extra_data=null) {
    if ($event_type_str === "init_config") {
        return false;
    }
    else if ($event_type_str === "recv_config") {
        // error_log("Holo6ConfigEventsCallback (recv_config : " . $file_path . ")");
        return true;
    }
    else if ($event_type_str === "write_config") {
        // error_log("Holo6ConfigEventsCallback (write_config : " . $file_path . ") : " . $extra_data);
        return true;
    }
    else if ($event_type_str === "recv_file") {
        // error_log("Holo6ConfigEventsCallback (recv_file : " . $file_path . ") : " . $extra_data);
        if (substr($file_path, -4) === ".png") {
            return true;
        }
    }
    else if ($event_type_str === "write_file") {
        // error_log("Holo6ConfigEventsCallback (write_file : " . $file_path . ") : " . $extra_data);
    }
    else if ($event_type_str === "remove_file") {
        // error_log("Holo6ConfigEventsCallback (remove_file : " . $file_path . ") : " . $extra_data);
        if (substr($file_path, -4) === ".png") {
            return true;
        }
    }
    return true;
}


if ($_SERVER["REQUEST_METHOD"] == "POST" && Holo6ControleAuth()) {
    $_post_data = file_get_contents("php://input");
    $events_callback_fct = "Holo6ConfigEventsCallback";
    $dossier_racine_abs = dirname(__FILE__);
    $dossier_destination_defaut = "files_fallback";
    $read_only_mode = false;
    H6CfgUploadMain($_post_data, $events_callback_fct, $dossier_racine_abs, $dossier_destination_defaut, $read_only_mode);
}
else {
    if (isset($_SERVER["HTTP_X_CSRF_TOKEN"])) {
        error_log("Holo6: Reject JSON data from " . $_SERVER["REMOTE_ADDR"] . ". Session tokens: provided(" . $_SERVER["HTTP_X_CSRF_TOKEN"] . "), requested(" . Configuration::get("HOLO6_LAST_SESSION_TOKEN") . ").");
    }
    else {
        error_log("Holo6: Reject JSON data from " . $_SERVER["REMOTE_ADDR"] . ". (No session token provided).");
    }
    header("HTTP/1.0 401 Unauthorized");
}

?>
