<?php

// declare(strict_types=1);

if (!defined("_PS_VERSION_")) {
    exit;
}

include_once dirname(__FILE__) . "/holo6_js/config/uploads/holo6_config_upload_mod.php";


function Holo6ConfigInitEventCallback($event_type_str, $file_path, $extra_data=null) {
    if ($event_type_str === "init_config") {
        // error_log("Holo6ConfigInitEventCallback (init_config : " . $file_path . ")");
        return true;
    }
    else if ($event_type_str === "recv_config") {
        return false;
    }
    else if ($event_type_str === "write_config") {
        // error_log("Holo6ConfigInitEventCallback (write_config : " . $file_path . ") : " . $extra_data);
        return true;
    }
    return false;
}


class Holo6Params {
    public function __construct() {
    }

    public function get_lang() {
        return "fr";  // "en" | "fr"  << A implémenter...
    }

    public function get_mini_client_variant() {
        return false;
    }

    public function get_pwa_enabled() {
        return false;
    }

    public function get_opensearch_enabled() {
        return false;
    }

    // public function get_PWA_URL() {
    //     $params_pwa_index = $this->get_mini_client_variant() ? "?h6_pwa_mini=1" :  "";
    //     return "https://" . $_SERVER["SERVER_NAME"] . "/modules/holo6ps/PWA/index.php" . $params_pwa_index;
    // }

    public function get_PWA_manifest_URL() {
        $params_pwa_index = $this->get_mini_client_variant() ? "?h6_pwa_mini=1" :  "";
        return "https://" . $_SERVER["SERVER_NAME"] . "/modules/holo6ps/PWA/manifest." . $this->get_lang() . ".json.php" . $params_pwa_index; // manifest.fr.json.php" />
    }

    public function get_OpenSearchURL() {
        return "https://" . $_SERVER["SERVER_NAME"] . "/modules/holo6ps/OpenSearch.xml.php";
    }
}


class Holo6ps extends Module {
    private $holo6_params = null;

    public function __construct()
    {
        $this->name = "holo6ps";
        $this->tab = "front_office_features";
        $this->author = "Holo6";
        $this->version = "0.1.0";
        $this->need_instance = 0;
        $this->ps_versions_compliancy = ["min" => "1.7.0", "max" => "9.99.99"];
        // $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->trans("Holo6", [], "Modules.Holo6ps.Config");
        $this->description = $this->trans("Holo6 Prestashop client", [], "Modules.Holo6ps.Config");
        $this->confirmUninstall = $this->trans("Are you sure you want to uninstall Holo6 ?", [], "Modules.Holo6ps.Admin");

        if (!Configuration::get("HOLO6_CLIENT_INSTALLED")) {
            $this->warning = $this->trans("HOLO6_CLIENT_INSTALLED not found. You should reinstall the Holo6 module.", [], "Modules.Holo6ps.Admin");
        }
        $this->holo6_params = new Holo6Params();
    }

    public function isUsingNewTranslationSystem() {
        return true;
    }

    public function install() {
        if (!parent::install()) {
            return false;
        }
        
        // https://devdocs.prestashop-project.org/9/modules/concepts/hooks/list-of-hooks/
        $this->registerHook("displayHeader");
        $this->registerHook("displayFooter");
        // $this->registerHook("displayHome");
        // $this->registerHook("displayProductExtraContentHome");
        $this->registerHook("displayTop");
        $this->registerHook("displaybackOfficeHeader");

        // error_log("REF : " . $this->_get_reference_path_conf()); // TEST

        if (!Configuration::updateValue("HOLO6_CLIENT_INSTALLED", "ok")) {
            return false;
        }

        $uploads_instance = new Holo6ConfigManager("Holo6ConfigInitEventCallback", null, null, false);
        $ignore_reset_if_exists = true;
        $liste_langues = Language::getLanguages(true, $this->context->shop->id, false);
        foreach ($liste_langues as $lang) {
            $uploads_instance->reset_default_agents_config($lang["iso_code"], $this->_get_uploads_subdir(), $ignore_reset_if_exists);
        }
        return true;
    }

    public function uninstall() {
        if (!parent::uninstall()) {
            return false;
        }
        return Configuration::deleteByName("HOLO6_CLIENT_INSTALLED");
        return Configuration::deleteByName("HOLO6_CONFIG_AUTH");
        return Configuration::deleteByName("HOLO6_LAST_SESSION_TOKEN");
    }

    public function check_admin() {
        return (Tools::getValue("controller") == "AdminModules") && (Tools::getValue("configure") === $this->name);
    }

    public function get_holo6_js_uri() {
        return $this->getPathUri() . "holo6_js/";
    }

    public function hookDisplayHeader($params) {
        $this->context->smarty->assign([
            "holo6_client_js_path" => $this->get_holo6_js_uri() . (($this->holo6_params->get_mini_client_variant()) ? $this->_get_h6_revision("holo6-mini.js") : $this->_get_h6_revision("holo6.js")),
            "holo6_client_css_path" => $this->get_holo6_js_uri() . (($this->holo6_params->get_mini_client_variant()) ? null : $this->_get_h6_revision("holo6.css")),
            "holo6_pwa_manifest_url" => $this->holo6_params->get_pwa_enabled() ? $this->holo6_params->get_PWA_manifest_URL() : null,
            "holo6_opensearch_url" => $this->holo6_params->get_opensearch_enabled() ? $this->holo6_params->get_OpenSearchURL() : null
        ]);
        return $this->display(__FILE__, "views/templates/hook/head_h6.tpl");
    }

    public function hookDisplayFooter($params) {
        // return $this->display(__FILE__, "footer.tpl");
        return $this->display(__FILE__, "views/templates/hook/footer.tpl");
    }

    // public function hookDisplayHome($params) {
    //     return $this->_load_holo6_client();
    // }

    public function hookDisplayTop($params) {
        return $this->_load_holo6_client();
    }

    // public function hookDisplayProductExtraContentHome($params) {
    //     return $this->_load_holo6_client();
    // }

    public function hookDisplaybackOfficeHeader() {
        if ($this->check_admin()) {
            /* Assigné en tant que variable et utilisé dans un patron pour pouvoir assigner le type de script "module". */
            $this->context->smarty->assign([
                "holo6_client_js_path" => $this->get_holo6_js_uri() . $this->_get_h6_revision("holo6.js"),
                "holo6_client_mini_js_path" => $this->get_holo6_js_uri() . $this->_get_h6_revision("holo6-mini.js"),
                "holo6_config_path" => $this->get_holo6_js_uri() . $this->_get_h6_revision("holo6_config.js"),
            ]);
            return $this->display(__FILE__, "views/templates/admin/head.tpl");
        }
    }
    
    public function initContent() {
        // $this->setTemplate("module:holo6ps/views/templates/hook/client.tpl");
        parent::initContent();
    }

    public function getContent() {
        // return "<div>TEST:HOLO6 (content) !</div>";
        if ($this->check_admin()) {       
            $session_token = Tools::getAdminTokenLite("AdminModules");
            $this->context->controller->addCSS($this->get_holo6_js_uri() . $this->_get_h6_revision("holo6_config.css"), "all");
            $this->context->controller->addCSS($this->get_holo6_js_uri() . $this->_get_h6_revision("holo6.css"), "all");

            Configuration::updateValue("HOLO6_LAST_SESSION_TOKEN", $session_token);
            
            $nom_role = $this->_get_current_holo6_role();
            $site_id = ($this->context->shop !== null) ? Tools::strtolower($this->context->shop->name) : "";
            // $site_id = ($this->context->shop !== null) ? $this->context->shop->getGroup()->name : "";
            $force_api_key_db = Configuration::get("HOLO6_CONFIG_AUTH");
            $force_api_key = (is_string($force_api_key_db) && strlen($force_api_key_db) > 0) ? $force_api_key_db : ("pk:" . $_SERVER["SERVER_NAME"]);
            $context_flags = "embedded:public";
            $this->context->smarty->assign([
                "lang" => "auto",
                "site_id" => $site_id,
                "force_api_key" => $force_api_key,
                "context_flags" => $context_flags,
                "csrf_token" => $session_token,
                "cfg_reference_file" => "",
                "cfg_reference_path" => $this->get_holo6_js_uri() . "config/base",
                "uploads_path" => $this->get_holo6_js_uri() . "config/uploads",
                "uploads_subdir" => $this->_get_uploads_subdir(),
                "auth_path" => $this->getPathUri() . "src/auth",
                "configuration_file_ui" => $this->_get_current_holo6_conf($nom_role),
                "configuration_file_cl" => $this->_get_current_holo6_conf("writer") // $this->_get_current_holo6_conf("writer") | $this->_get_reference_path_conf()
            ]);
            if ($this->holo6_params->get_mini_client_variant()) {
                return $this->context->smarty->fetch("module:holo6ps/views/templates/admin/h6_config.tpl") . $this->context->smarty->fetch("module:holo6ps/views/templates/admin/h6_client_mini.tpl");
            }
            else {
                return $this->context->smarty->fetch("module:holo6ps/views/templates/admin/h6_config.tpl") . $this->context->smarty->fetch("module:holo6ps/views/templates/admin/h6_client.tpl");
            }
        }
    }

    private function _load_holo6_client() {
        $nom_role = $this->_get_current_holo6_role();
        $this->context->smarty->assign([
            "agent_role" => $nom_role,
            "avatar_url" => $this->get_holo6_js_uri() . "avatars/base/avatar.json",
            "configuration_file" => $this->_get_current_holo6_conf($nom_role),
            "configuration_inline" => ""
        ]);
        if ($this->holo6_params->get_mini_client_variant()) {
            return $this->display(__FILE__, "views/templates/hook/holo6_client_mini_top.tpl");
        }
        else {
            // return $this->display(__FILE__, "holo6_client_top.tpl");
            return $this->display(__FILE__, "views/templates/hook/holo6_client_top.tpl");
        }
    }

    private function _get_current_holo6_role() {
        if ($this->check_admin()) {
            // return "writer";
            return "public";
        }
        else {
            return "public";
        }
    }

    protected function _get_uploads_subdir() {
        return "1";
    }

    private function _get_current_holo6_conf($nom_role) {
        $prefixe = "Holo6Config";
        // $suffixe = "@" . $_SERVER["SERVER_NAME"] . ".json";
        $suffixe = ".json";
        $nom_fichier_json = $prefixe . "-" . $nom_role . $suffixe;
        return $this->get_holo6_js_uri() . "config/uploads/" . $this->_get_uploads_subdir() . "/" . $nom_fichier_json;
    }

    protected function _get_reference_path_conf() {
        $base_path = "config/base/";
        $liste_langues = Language::getLanguages(true, $this->context->shop->id, false);
        foreach ($liste_langues as $lang) {
            $nom_fichier = "Holo6Config-base-" . $lang["iso_code"] . ".json";
            if (file_exists(dirname(__FILE__) . "/holo6_js/" . $base_path . $nom_fichier)) {
                return $base_path . $nom_fichier;
            }
        }
        return $base_path . "Holo6Config-base-en.json";  // "config/base/Holo6Config-base-fr.json"
    }

    protected function _get_h6_revision($chemin_rel_h6_js) {
        $chemin_abs = dirname(__FILE__) . "/holo6_js/" . $chemin_rel_h6_js;
        if (file_exists($chemin_abs)) {
            return $chemin_rel_h6_js . "?ver=" . date("dmy-Gis", filemtime($chemin_abs));
        }
        else {
            return $chemin_rel_h6_js . "?ver=" . $this->version;
        }
    }
}

?>