<?php

/*
    Sera appelé par le client après l'authentification (voir Holo6GestionCompteUtilisateur._post_auth_notification()).
    Afin de notifier au serveur que le client Javascript s'est bien connecté.
    Peut être ignoré dans l'absolu mais ça peut être utile pour stocker le mot de passe du compte côté serveur et le renvoyer ensuite en appelant le client avec le paramètre 'force_api_key'.

    Ce fichier est un simple exemple et peut être ignoré si l'on ne souhaite pas enregistrer les idendifiants dans la base de données.
*/


$CHEMIN_RACINE_PRESTASHOP = realpath(dirname(__FILE__) . "/../../../../");
require_once($CHEMIN_RACINE_PRESTASHOP . "/config/config.inc.php");
require_once($CHEMIN_RACINE_PRESTASHOP . "/init.php");

header("Content-Type: text/plain");


function Holo6ControleAuth() {
    if (isset($_SERVER["HTTP_X_CSRF_TOKEN"])) {  // Envoyé par le client de configuration si la variable csrf_token lui a été assigné.
        $CSRF_TOKEN = $_SERVER["HTTP_X_CSRF_TOKEN"];
        $instance_module = Module::getInstanceByName("holo6ps");
        if ($instance_module) {
            $last_session_token = Configuration::get("HOLO6_LAST_SESSION_TOKEN");
            if (is_string($last_session_token) && (strlen($last_session_token) > 0) && ($last_session_token === $CSRF_TOKEN)) {  // Validation du jeton de session...
                return true;
            }
        }
    }
    return false;
}


function Holo6UpdateDatabase($api_key, $secret_key) {
    if (is_string($api_key) && strlen($api_key) > 0) {
        if (is_string($secret_key) && strlen($secret_key) > 0) {
            /* Met à jour la base de données avec la clé. */
            if (Configuration::updateValue("HOLO6_CONFIG_AUTH", $api_key . ":" . $secret_key)) {
                // error_log("UPDATE (h):" . Configuration::get("HOLO6_CONFIG_AUTH"));  // TEST
                return true;
            }
        }
        else {  /* Supprime la clé de la base de données. */
            // return Configuration::deleteByName("HOLO6_CONFIG_AUTH");
            // error_log("DELETE (h):" . Configuration::deleteByName("HOLO6_CONFIG_AUTH"));  // TEST
            if (Configuration::updateValue("HOLO6_CONFIG_AUTH", $api_key)) {
                return true;
            }
        }
    }
    return false;
}


if (($_SERVER["REQUEST_METHOD"] == "POST") && Holo6ControleAuth()) {
    $_post_data = json_decode(file_get_contents("php://input"), true);
    if (isset($_post_data["command"])) {
        if ($_post_data["command"] === "auth_notification") {
            $api_key = $_post_data["arguments"]["api_key"];
            $secret_key = $_post_data["arguments"]["secret_key"];
            if (Holo6UpdateDatabase($api_key, $secret_key)) {
                echo("ok"); // Valeur attendue si tout s'est bien passé.
            }
        }
        else if ($_post_data["command"] === "auth_disconnect") {
            $api_key = $_post_data["arguments"]["api_key"];
            if (Holo6UpdateDatabase($api_key, null)) {
                echo("ok"); // Valeur attendue si tout s'est bien passé.
            }
        }
    }
}

?>
