<?php
  header("Content-Type: application/json; charset=utf-8", true);
  
  function SiteURL() {
    $protocol = (!empty($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] !== "off" || $_SERVER["SERVER_PORT"] == 443) ? "https://" : "http://";
    return $protocol . $_SERVER["SERVER_NAME"];
  }

  function URL_PWA_ROOT() {
    $script_name = dirname($_SERVER["SCRIPT_NAME"]);
    if ($script_name === "/") {
      return SiteURL() . "/";
    }
    else {
      return SiteURL() . $script_name . "/";
    }
  }

  function IndexParams() {
    return (isset($_GET["h6_pwa_mini"]) && ($_GET["h6_pwa_mini"] != 0)) ? "?h6_pwa_mini=1" : "";
  }

  $PWA_ROOT_URL = URL_PWA_ROOT();
?>
{
  "name": "Holo6 - <?php echo($_SERVER["SERVER_NAME"]); ?>",
  "short_name": "Holo6 - <?php echo($_SERVER["SERVER_NAME"]); ?>",
  "description": "L'IA publique de <?php echo($_SERVER["SERVER_NAME"]); ?>",
  "id": "<?php echo(SiteURL() . "/"); ?>",
  "lang": "fr",
  "icons": [
    {
      "src": "<?php echo($PWA_ROOT_URL); ?>favicon-64x64.png",
      "sizes": "64x64",
      "type": "image/png"
    },
    {
      "src": "<?php echo($PWA_ROOT_URL); ?>favicon-192x192.png",
      "sizes": "192x192",
      "type": "image/png"
    },
    {
      "src": "<?php echo($PWA_ROOT_URL); ?>favicon-512x512.png",
      "sizes": "512x512",
      "type": "image/png"
    }
  ],
  "start_url": "<?php echo($PWA_ROOT_URL . "index.php" . IndexParams()); ?>",
  "scope": "<?php echo($PWA_ROOT_URL); ?>",
  "display_override": ["standalone"],
  "display": "fullscreen",
  "orientation": "portrait",
  "background_color": "#ffffff",
  "theme_color": "#ffffff",
  "related_applications": [
  ]
}