<?php

/**
 * Plugin Name: Holo6
 * Plugin URI: https://holo6.com
 * Description: Holo6 allows you to integrate a chat window into your website and enable users to interact with an AI agent.
 * License URI: https://cecill.info/licences/Licence_CeCILL-C_V1-fr.txt
 * Version: 0.1
 * Author: Florian Joncour
 * Author URI: holo6.com
 * License: CeCILL-C
 * Requires at least: 4.4
 * Requires PHP: 5.0
 * Text Domain: holo6
 * Domain Path: /languages
 */

define("HOLO6_PLUGIN_VERSION", "0.1");
define("HOLO6_PLUGIN_BASENAME", plugin_basename(__FILE__));


// Editeur : https://developer.wordpress.org/block-editor/getting-started/fundamentals/javascript-in-the-block-editor/

if (!defined("ABSPATH")) {
    die("We\'re sorry, but you can not directly access this file.");
}

// Make sure we don't expose any info if called directly
if (!function_exists("add_action")) {
    echo("Hi there!  I\'m just a plugin, not much I can do when called directly.");
    exit;
}

define("HOLO6_PLUGIN_DIR", plugin_dir_path(__FILE__) . "/");
define("HOLO6_PLUGIN_URL", plugin_dir_url(__FILE__));
define("HOLO6_CLIENT_DIR", HOLO6_PLUGIN_DIR . "holo6_js/");
define("HOLO6_CLIENT_URL", HOLO6_PLUGIN_URL . "holo6_js/");


require_once constant("HOLO6_PLUGIN_DIR") . "plugin_init.php";
register_activation_hook(__FILE__, array("Holo6PluginInstall", "activate"));
register_deactivation_hook(__FILE__, array("Holo6PluginInstall", "deactivate"));

add_action("upgrader_pre_install", array("Holo6PluginInstall", "serialize_before_update"), 10, 2); // Le problème c'est que c'est appelé pour chaque installation de module, y compris étranger...
add_action("upgrader_post_install", array("Holo6PluginInstall", "restore_after_update"), 10, 3); // Le problème c'est que c'est appelé pour chaque installation de module, y compris étranger...

require_once constant("HOLO6_PLUGIN_DIR") . "plugin_pages/libs/utils.php";
require_once constant("HOLO6_PLUGIN_DIR") . "plugin_pages/holo6_pages.php";
require_once constant("HOLO6_PLUGIN_DIR") . "plugin_pages/libs/holo6_client_settings.php";
require_once constant("HOLO6_PLUGIN_DIR") . "plugin_pages/libs/holo6_common_settings.php";

function holo6_filter_script_module_tag($tag, $handle, $src)
{
    if ($handle === "holo6_ui") {
        $tag = "<script type=\"module\" src=\"" . esc_url($src) . "\"></script>";
    }
    return $tag;
}

function load_holo6_textdomain( $mofile, $domain ) {
    if ($domain === "holo6") {
        $mofile = str_replace("holo6/plugin_pages/languages", "holo6/languages", $mofile);
        $mofile = str_replace("holo6languages", "holo6/languages", $mofile); /* Petit soucis avec les anciennes versions comme la 3.0 ?! */
        if (strpos($mofile, WP_LANG_DIR . "/plugins/") !== false) {
            $locale = apply_filters("plugin_locale", get_locale(), $domain);
            $mofile = WP_PLUGIN_DIR . "/" . dirname(HOLO6_PLUGIN_BASENAME) . "/languages/" . $domain . "-" . $locale . ".mo";
        }
    }
	return $mofile;
}

class Holo6JSClient {
	private static $_scripts_initiated = false;
	private static $_head_initiated = false;

    public static function init_scripts() {
        if ( ! self::$_scripts_initiated ) {
            $client_settings = Holo6JSClientSettings::SelectSettingsCTOR(holo6_is_current_admin());
            if ($client_settings->get_app_enabled_option() === true) {
                if (file_exists(constant("HOLO6_CLIENT_DIR") . "holo6.css") === true) {  // Il est possible que le fichier de style n'existe pas si il est intégré au fichier js.
                    wp_enqueue_style("holo6_ui_style", constant("HOLO6_CLIENT_URL") . "holo6.css", array(), holo6_client_format_mtime_file("holo6.css"));
                }

                $common_settings = new Holo6CommonSettings();
                $n_script = $common_settings->get_mini_client_variant() ? "holo6-mini.js" : "holo6.js";
    
                if (function_exists("wp_enqueue_script_module")) { // A partir de WP 6.5
                    wp_enqueue_script_module("holo6_ui_js", constant("HOLO6_CLIENT_URL") . $n_script, array(), holo6_client_format_mtime_file($n_script));
                }
                else {  // Toute version:
                    // add_filter("script_loader_tag", "holo6_filter_script_module_tag", 10, 3); // Hook WP 4.1
                    echo("	<script type=\"module\" src=\"" . esc_url(constant("HOLO6_CLIENT_URL") . $n_script . "?ver=" . holo6_client_format_mtime_file($n_script)) . "\"></script>");
                }

                if (holo6_is_current_admin()) {
                }
                else {  // Site public.
                    if ($common_settings->get_opensearch_enabled() === true) {  // Injection OpenSearch:
                        echo("	<link rel=\"search\" type=\"application/opensearchdescription+xml\" title=\"Holo6\" href=\"" . constant("HOLO6_PLUGIN_URL") . "OpenSearch.xml.php\" />\n");
                    }
                }
            }
            self::$_scripts_initiated = true;
        }
    }
    
    public static function init_head() {
        if ( ! self::$_head_initiated ) {
            if (holo6_is_current_admin()) {
            }
            else {  // Site public.
                $common_settings = new Holo6CommonSettings();
                if ($common_settings->get_pwa_enabled() === true) {  // Injection PWA:
                    $locale_site = get_locale();
                    $params_manifest = ($common_settings->get_mini_client_variant() === true) ? "?h6_pwa_mini=1" : "";
                    if (holo6_str_startsWith($locale_site, "fr")) {
                        echo("<link rel=\"manifest\" href=\"" . constant("HOLO6_PLUGIN_URL") . "PWA/manifest.fr.json.php" . $params_manifest . "\" />\n");
                    }
                    else if (holo6_str_startsWith($locale_site, "en")) {
                        echo("<link rel=\"manifest\" href=\"" . constant("HOLO6_PLUGIN_URL") . "PWA/manifest.en.json.php" . $params_manifest . "\" />\n");
                    }
                }
            }
        }
        self::$_head_initiated = true;
    }

    public static function end() {
        $currently_admin = holo6_is_current_admin();
        $client_settings = Holo6JSClientSettings::SelectSettingsCTOR($currently_admin);
        if ($client_settings->get_app_enabled_option() === true) {
            require_once constant("HOLO6_PLUGIN_DIR") . "plugin_pages/libs/holo6_private_settings.php";
            $avatar_bot_param = ($client_settings->get_ui_show_avatar_option()) ? " avatar_url=\"avatars/base/avatar.json\"" : "";
            $holo6_ui_window_dockable = $client_settings->get_ui_window_dockable_option();
            if ($holo6_ui_window_dockable === null) {  // Absent de la BDD...
                $holo6_ui_window_dockable = $client_settings->ui_window_dockable;
            }
            $common_settings = new Holo6CommonSettings();
            $tag_name = ($common_settings->get_mini_client_variant() === true) ? "holo6-mini" : "holo6-app";
            if ($currently_admin) {  // IA privée, avec mot de passe pour accéder aux données privées
                $private_settings = new Holo6PrivateSettings();
                $api_key_param = $private_settings->get_inline_config_api_key_html_param();
                $current_page = $_SERVER["REQUEST_URI"];
                if (strpos($current_page, "page=holo6-settings-public") !== false) {
                    echo("<" . $tag_name . " app_mode=\"ui\"" . $avatar_bot_param . " configuration_file=\"" . $client_settings->get_holo6_conf_path("public", true) . "\"" . $api_key_param . " agent_role=\"public\"></" . $tag_name . ">\n");
                }
                else if (strpos($current_page, "page=holo6-settings-admin") !== false) {
                    echo("<" . $tag_name . " app_mode=\"ui\"" . $avatar_bot_param . " configuration_file=\"" . $client_settings->get_holo6_conf_path("writer", true) . "\"" . $api_key_param . " agent_role=\"writer\"></" . $tag_name . ">\n");
                }
                else {  // Le reste de l'espace admin
                    echo("<" . $tag_name . " app_mode=\"ui\"" . $avatar_bot_param . " configuration_file=\"" . $client_settings->get_holo6_conf_path("writer", true) . "\"" . $api_key_param . " agent_role=\"writer\"></" . $tag_name . ">\n");
                }
                echo("<" . $tag_name . " app_mode=\"cl:client\" configuration_file=\"" . $client_settings->get_holo6_conf_path("summarizer", true) . "\"" . $api_key_param . "></" . $tag_name . ">\n");
            }
            else {  // IA Publique, sans mots de passe défini
                if ($holo6_ui_window_dockable === true) {
                    echo("<" . $tag_name . " app_mode=\"ui\"" . $avatar_bot_param . " configuration_file=\"" . $client_settings->get_holo6_conf_path("public", true) . "\"></" . $tag_name . ">\n");
                }
            }
        }
    }

    public static function add_into_admin_menu($wp_admin_bar) {
        $currently_admin = holo6_is_current_admin();
        if ($currently_admin) {

        }
        else {
            $wp_admin_bar->add_menu(
                array(
                    "id" => "holo6_admin_menu",
                    "parent" => null,
                    "group"  => null,
                    "title" => "<span><img style=\"width: 20px; height: 20px; padding: 0 4px 0 0;\" alt=\"\" src=\"data:image/svg+xml;base64,PHN2ZyB4bWxucz0naHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmcnIGZpbGw9JyM5YWEwYTUnIHZpZXdCb3g9JzAgMCAyNCAyNCc+PHRpdGxlPnJvYm90LW91dGxpbmU8L3RpdGxlPjxwYXRoIGQ9J00xNy41IDE1LjVDMTcuNSAxNi42MSAxNi42MSAxNy41IDE1LjUgMTcuNVMxMy41IDE2LjYxIDEzLjUgMTUuNSAxNC40IDEzLjUgMTUuNSAxMy41IDE3LjUgMTQuNCAxNy41IDE1LjVNOC41IDEzLjVDNy40IDEzLjUgNi41IDE0LjQgNi41IDE1LjVTNy40IDE3LjUgOC41IDE3LjUgMTAuNSAxNi42MSAxMC41IDE1LjUgOS42MSAxMy41IDguNSAxMy41TTIzIDE1VjE4QzIzIDE4LjU1IDIyLjU1IDE5IDIyIDE5SDIxVjIwQzIxIDIxLjExIDIwLjExIDIyIDE5IDIySDVDMy45IDIyIDMgMjEuMTEgMyAyMFYxOUgyQzEuNDUgMTkgMSAxOC41NSAxIDE4VjE1QzEgMTQuNDUgMS40NSAxNCAyIDE0SDNDMyAxMC4xMyA2LjEzIDcgMTAgN0gxMVY1LjczQzEwLjQgNS4zOSAxMCA0Ljc0IDEwIDRDMTAgMi45IDEwLjkgMiAxMiAyUzE0IDIuOSAxNCA0QzE0IDQuNzQgMTMuNiA1LjM5IDEzIDUuNzNWN0gxNEMxNy44NyA3IDIxIDEwLjEzIDIxIDE0SDIyQzIyLjU1IDE0IDIzIDE0LjQ1IDIzIDE1TTIxIDE2SDE5VjE0QzE5IDExLjI0IDE2Ljc2IDkgMTQgOUgxMEM3LjI0IDkgNSAxMS4yNCA1IDE0VjE2SDNWMTdINVYyMEgxOVYxN0gyMVYxNlonIC8+PC9zdmc+\" />" . __("Holo6: Add this page to the database", "holo6") . "</span>",
                    "href" => admin_url() . "admin.php?page=holo6-settings-public&auto_redact_pub='" . rawurlencode(get_permalink()) . "'",
                    // "meta" => [ "title" => __("Create or edit a new database entry", "holo6"), ]
                )
            );
        }
    }
}


if ( holo6_is_current_admin() || ( defined("WP_CLI") && defined("WP_CLI") ) ) {
//     add_action("init", array("Holo6JSClient", "init"));
    add_action("admin_enqueue_scripts", array("Holo6JSClient", "init_scripts"));
    add_action("admin_footer", array("Holo6JSClient", "end"), 999);
    add_filter("load_textdomain_mofile", "load_holo6_textdomain", 10, 2);
    load_plugin_textdomain("holo6", false, dirname(HOLO6_PLUGIN_BASENAME) . "/languages");
	add_action("init", array("Holo6Pages", "init"));
}
else {
    add_action("wp_enqueue_scripts", array("Holo6JSClient", "init_scripts"));
    add_action("wp_footer", array("Holo6JSClient", "end"), 999);
	add_action("wp_head", array("Holo6JSClient", "init_head"));
    load_plugin_textdomain("holo6", false, dirname(HOLO6_PLUGIN_BASENAME) . "/languages");
    add_action("admin_bar_menu", array("Holo6JSClient", "add_into_admin_menu"), 100);
}


function holo6_never_called_function() {
    /* Cette fonction ne sera pas utilisée, elle n'a pour but que de définir forcer l'extraction de certaines traductions. */
    __("Holo6 allows you to integrate a chat window into your website and enable users to interact with an AI agent.", "holo6");

    // Depuis javascript:
    // __("Access denied: page is in edit mode", "holo6");
    // __("Fetch error (exception)", "holo6");
    // __("holo6-cl not found", "holo6");
}
?>