<?php

/*
    Sera appelé par le client après l'authentification (voir Holo6GestionCompteUtilisateur._post_auth_notification()).
    Afin de notifier au serveur que le client Javascript s'est bien connecté.
    Peut être ignoré dans l'absolu mais ça peut être utile pour stocker le mot de passe du compte côté serveur et le renvoyer ensuite en appelant le client avec le paramètre 'force_api_key'.

    Ce fichier est un simple exemple et peut être ignoré si l'on ne souhaite pas enregistrer les idendifiants dans la base de données.
*/

header("Content-Type: text/plain");

require_once($_SERVER["DOCUMENT_ROOT"] . "/wp-load.php");

if (!defined("ABSPATH")) {
    die("We're sorry, but you can not directly access this file.");
}

if (!function_exists("add_action") || !defined("HOLO6_PLUGIN_BASENAME")) {
    echo("Hi there!  I'm just a plugin, not much I can do when called directly.");
    exit;
}

require_once constant("HOLO6_PLUGIN_DIR") . "plugin_pages/libs/holo6_private_settings.php";


function Holo6ControleAuth() {
    if (isset($_SERVER["HTTP_X_CSRF_TOKEN"])) {  // Envoyé par le client de configuration si la variable csrf_token lui a été assigné.
        $CSRF_TOKEN = $_SERVER["HTTP_X_CSRF_TOKEN"];

        // Validation du jeton de session...
        $last_session_token = get_site_option("holo6_last_session_token", null);
        if (is_string($last_session_token) && (strlen($last_session_token) > 0) && ($last_session_token === $CSRF_TOKEN)) {  // Validation du jeton de session...
            return true;
        }
    }
    return false;
}


function Holo6UpdateDatabase($api_key, $secret_key) {
    if ((is_string($api_key) && strlen($api_key) > 0)) {
        $private_settings = new Holo6PrivateSettings();
        if (is_string($secret_key) && strlen($secret_key) > 0) {
            $private_settings->setSecretAPIKey($secret_key);
        }
        else {
            $private_settings->resetPasswords();
        }
    }
    return false;
}


if (($_SERVER["REQUEST_METHOD"] == "POST") && Holo6ControleAuth()) {
    $_post_data = json_decode(file_get_contents("php://input"), true);
    if (isset($_post_data["command"])) {
        if ($_post_data["command"] === "auth_notification") {
            $api_key = $_post_data["arguments"]["api_key"];
            $secret_key = $_post_data["arguments"]["secret_key"];
            if (Holo6UpdateDatabase($api_key, $secret_key)) {
                echo("ok"); // Valeur attendue si tout s'est bien passé.
            }
        }
        else if ($_post_data["command"] === "auth_disconnect") {
            $api_key = $_post_data["arguments"]["api_key"];
            if (Holo6UpdateDatabase($api_key, null)) {
                echo("ok"); // Valeur attendue si tout s'est bien passé.
            }
        }
    }
}


echo("ok"); // Valeur attendue si tout s'est bien passé. A retirer en production.

?>
