<?php /* Gère l"envoi et le stockage des fichiers de configuration (version Prestashop). l6*/


require_once($_SERVER["DOCUMENT_ROOT"] . "/wp-load.php");

if (!defined("ABSPATH")) {
    die("We're sorry, but you can not directly access this file.");
}

if (!function_exists("add_action") || !defined("HOLO6_PLUGIN_BASENAME")) {
    echo("Hi there!  I'm just a plugin, not much I can do when called directly.");
    exit;
}

// require_once constant("HOLO6_PLUGIN_DIR") . "plugin_pages/libs/utils.php";
require_once constant("HOLO6_PLUGIN_DIR") . "plugin_pages/libs/holo6_client_settings.php";
require_once plugin_dir_path(__FILE__) . "/holo6_config_upload_mod.php";


if ( ! current_user_can("upload_files") ) {
    wp_die(__("Rejected", "holo6"));
}


function Holo6ControleAuth() {
    if (isset($_SERVER["HTTP_X_CSRF_TOKEN"])) {  // Envoyé par le client de configuration si la variable csrf_token lui a été assigné.
        $CSRF_TOKEN = $_SERVER["HTTP_X_CSRF_TOKEN"];
        $last_session_token = get_site_option("holo6_last_session_token", null);
        if (is_string($last_session_token) && (strlen($last_session_token) > 0) && ($last_session_token === $CSRF_TOKEN)) {  // Validation du jeton de session...
            return true;
        }
    }
    return false;
}


// function Holo6ConfigEventsCallback($event_type_str, $file_path, $extra_data=null) {
//     if ($event_type_str === "init_config") {
//         return false;
//     }
//     else if ($event_type_str === "recv_config") {
//         // error_log("Holo6ConfigEventsCallback (recv_config : " . $file_path . ")");
//         return true;
//     }
//     else if ($event_type_str === "write_config") {
//         // error_log("Holo6ConfigEventsCallback (write_config : " . $file_path . ") : " . $extra_data);
//         return true;
//     }
//     return false;
// }


if ($_SERVER["REQUEST_METHOD"] == "POST" && Holo6ControleAuth()) {
    $_post_data = file_get_contents("php://input");
    $events_callback_fct = "Holo6ConfigEventsCallback";  /* Défini dans holo6_client_settings.php */
    $dossier_racine_abs = dirname(__FILE__);
    $dossier_destination_defaut = "files_fallback";
    $read_only_mode = false;
    H6CfgUploadMain($_post_data, $events_callback_fct, $dossier_racine_abs, $dossier_destination_defaut, $read_only_mode);
}
else {
    if (isset($_SERVER["HTTP_X_CSRF_TOKEN"])) {
        error_log("Holo6: Reject JSON data from " . $_SERVER["REMOTE_ADDR"] . ". Session tokens: provided(" . $_SERVER["HTTP_X_CSRF_TOKEN"] . "), requested(" . get_site_option("holo6_last_session_token", null) . ").");
    }
    else {
        error_log("Holo6: Reject JSON data from " . $_SERVER["REMOTE_ADDR"] . ". (No session token provided).");
    }
    header("HTTP/1.0 401 Unauthorized");
}

?>
