<?php

/* 
    Gère la préparation et la finalisation des mises à jour pour générer et/ou conserver les fichiers de configuration.
    
    Il y a un problème majeur qui est qu'il n'y a pas de hook spécifique pour ce cas d'usage (en particulier pour la sauvegarde des paramètres avant une réinstallation ou une mises à jour).
    upgrader_pre_install et upgrader_post_install sont donc utilisés, mais ils sont appelés pour chaque mises à jour de n'importe quel module.

    Le problème c'est qu'il y aura donc un cycle de sauvegarde/restauration lors de la mise à jour de chaque module...
*/


require_once __DIR__ . "/plugin_pages/libs/utils.php";
require_once __DIR__ . "/plugin_pages/libs/holo6_client_settings.php";
// require_once __DIR__ . "/plugin_pages/libs/holo6_common_settings.php";
include_once __DIR__ . "/holo6_js/config/uploads/holo6_config_upload_mod.php";

// include_once ABSPATH . "wp-admin/includes/plugin.php";

class Holo6PluginInstall {

    public static function activate() {
        /* Appelé après juste après l'activation du plugin. */
        $plugin_state = self::_get_plugin_state_int();
        $sites_id_list = holo6_get_sites_id_list();
        foreach ( $sites_id_list as $current_network_id ) {
            if ($plugin_state === null || $plugin_state === 0) {  // Il s'agit d'une nouvelle installation
                self::_reset_settings($current_network_id, "public", false);
                self::_reset_settings($current_network_id, "writer", false);
                self::_reset_settings($current_network_id, "summarizer", false);
            }
            else {
                if ($plugin_state === 100) { // Il s'agit d'une mise à jour.
                    self::_restore_after_update($current_network_id, $plugin_state);
                }
                else { // Il s'agit d'un simple cycle activation/desactivation.
                    // delete_site_option("holo6_plugin_state");
                    self::_reset_settings($current_network_id, "public", true);
                    // self::_reset_settings($current_network_id, "writer", true);
                    self::_reset_settings($current_network_id, "summarizer", true);
                }
            }
        }
        if ($plugin_state === null || $plugin_state === 0) {  // Il s'agit d'une nouvelle installation
            update_site_option("holo6_plugin_state", 1);
            update_site_option("holo6_plugin_installed_version", HOLO6_PLUGIN_VERSION);
        }
    }

    public static function deactivate() {
    }

    public static function serialize_before_update() {
        /* Appelé avant une mise à jour. */
        $sites_id = holo6_get_sites_id_list();
        foreach ( $sites_id as $current_network_id ) {
            $settings_public = new Holo6JSClientSettings("public");
            update_network_option($current_network_id, "holo6_public_settings_data", $settings_public->get_file_data_site_id($current_network_id));    
            $settings_writer = new Holo6JSClientSettings("writer");
            update_network_option($current_network_id, "holo6_writer_settings_data", $settings_writer->get_file_data_site_id($current_network_id));
    
        }
        update_site_option("holo6_plugin_state", 100);
    }

    public static function restore_after_update() {
        $plugin_state = self::_get_plugin_state_int();
        $sites_id = holo6_get_sites_id_list();
        foreach ( $sites_id as $current_network_id ) {
            self::_restore_after_update($current_network_id, $plugin_state);
        }
    }

    public static function _restore_after_update($current_network_id, $plugin_state) {
        if ($plugin_state === 100) { // Il s'agit bien d'une mise à jour.
            self::_restore_or_init($current_network_id, "public");
            self::_restore_or_init($current_network_id, "writer");
            self::_reset_settings($current_network_id, "summarizer", false);
            update_site_option("holo6_plugin_state", 1);
        }
    }

    private static function _reset_settings($current_network_id, $name, $ignore_if_exists=false) {
        $settings = new Holo6JSClientSettings($name);
        if ($ignore_if_exists && $settings->json_file_exists_site_id($current_network_id)) {
            ;
        }
        else {
            // if ($name === "summarizer") {
            //     $settings->app_enabled = true;
            // }
            $settings->reset_default_settings($name, $current_network_id);
        }
    }

    // private static function ensure_exists($name) {
    //     self::_reset_settings($name, true);
    // }

    private static function _restore_or_init($current_network_id, $name) {
        $json_data = get_network_option($current_network_id, "holo6_" . $name . "_settings_data", null);  // Si des paramètres ont été sauvegardés...
        if ($json_data !== null) {
            $settings = new Holo6JSClientSettings($name);
            $settings->export_settings_json($json_data, $current_network_id);
            // update_network_option(Holo6CommonSettings::get_common_site_id(), "holo6_app_enabled", true);
            delete_network_option($current_network_id, "holo6_" . $name . "_settings_data");
        }
        else {
            self::_reset_settings($current_network_id, $name, false);
        }
    }

    private static function _get_plugin_state_int() {
        $plugin_state = get_site_option("holo6_plugin_state", null);
        if (is_string($plugin_state)) {
            $plugin_state = intval($plugin_state);
        }
        return $plugin_state;
    }
}

?>