<?php

require_once constant("HOLO6_PLUGIN_DIR") . "plugin_pages/libs/utils.php";
require_once constant("HOLO6_PLUGIN_DIR") . "plugin_pages/libs/holo6_private_settings.php";
require_once constant("HOLO6_PLUGIN_DIR") . "plugin_pages/main_settings/main_settings_page.php";


class Holo6Pages {
	private static $initiated = false;
// 	private static $settings = null;
	private static $settings_submenu_mode = false;

	public static function init() {
		if ( ! self::$initiated ) {
            $admin_profil = holo6_is_current_admin();
			self::init_hooks();
		    self::$initiated = true;
            add_action("admin_enqueue_scripts", array("Holo6Pages", "holo6_admin_enqueue_scripts"), 999);

            self::_init_blocks_editor();
		}
	}

    public static function holo6_admin_enqueue_scripts() {
        $current_page = $_SERVER["REQUEST_URI"];
        if (strpos($current_page, "?page=holo6-") !== false) {
            if ((strpos($current_page, "?page=holo6-settings-public") !== false) ||
                (strpos($current_page, "page=holo6-settings-admin") !== false)) {
                wp_enqueue_style("holo6-admin_pages", constant("HOLO6_PLUGIN_URL") . "holo6_js/holo6_config.css", array(), holo6_plugin_format_mtime_file("holo6_js/holo6_config.css"));

                if (function_exists("wp_enqueue_script_module")) { // A partir de WP 6.5
                    wp_enqueue_script_module("holo6-config", constant("HOLO6_PLUGIN_URL")  . "holo6_js/holo6_config.js", array(), holo6_plugin_format_mtime_file("holo6_js/holo6_config.js"));
                }
                else { // Toute version:
                    echo("<script type=\"module\" src=\"" . esc_url(constant("HOLO6_PLUGIN_URL") . "\"holo6_js/holo6_config.js?ver=" . holo6_plugin_format_mtime_file("holo6_js/holo6_config.js")) . "\"></script>");
                }
            }
            else if (strpos($current_page, "?page=holo6-settings-main") !== false) {
                if (function_exists("wp_enqueue_script_module")) { // A partir de WP 6.5
                    wp_enqueue_script("holo6-jquery", constant("HOLO6_PLUGIN_URL")  . "app/qrcodejs/jquery.min.js", array(), holo6_plugin_format_mtime_file("app/qrcodejs/jquery.min.js"));
                    wp_enqueue_script("holo6-qrcode", constant("HOLO6_PLUGIN_URL")  . "app/qrcodejs/qrcode.min.js", array(), holo6_plugin_format_mtime_file("app/qrcodejs/qrcode.min.js"));
                    wp_enqueue_script_module("holo6-autogen_qrcode", constant("HOLO6_PLUGIN_URL")  . "app/qrcodejs/autogen_qrcode.js", array(), holo6_plugin_format_mtime_file("app/qrcodejs/autogen_qrcode.js"));
                }
                else { // Toute version:
                    echo("<script type=\"text/javascript\" src=\"" . esc_url(constant("HOLO6_PLUGIN_URL") . "\"app/qrcodejs/jquery.min.js?ver=" . holo6_plugin_format_mtime_file("app/qrcodejs/jquery.min.js")) . "\"></script>");
                    echo("<script type=\"text/javascript\" src=\"" . esc_url(constant("HOLO6_PLUGIN_URL") . "\"app/qrcodejs/qrcode.min.js?ver=" . holo6_plugin_format_mtime_file("app/qrcodejs/qrcode.min.js")) . "\"></script>");
                    echo("<script type=\"module\" src=\"" . esc_url(constant("HOLO6_PLUGIN_URL") . "\"app/qrcodejs/autogen_qrcode.js?ver=" . holo6_plugin_format_mtime_file("app/qrcodejs/autogen_qrcode.js")) . "\"></script>");
                }
            }
        }
    }

	public static function init_hooks() {
		add_action("admin_init", array("Holo6Pages", "admin_init"));
		add_action("admin_menu", array("Holo6Pages", "admin_menu"), 5);
        add_action("admin_notices", array("Holo6Pages", "admin_notice_errors"));
    }

	public static function admin_init() {
	}

	public static function admin_menu() {
        add_action("admin_menu", array("Holo6Pages", "holo6_menu"));
	}

    public static function admin_notice_errors() {
        Holo6NotificationsRenderHTML();
    }

    public static function holo6_menu() {
        if (self::$settings_submenu_mode) { // Si sous-section dans les réglages:
            add_options_page("Holo6", __("Holo6 AI", "holo6"), "manage_options", "holo6-plugin", array("Holo6Pages", "render_plugin_settings_page_public"));
            add_options_page("Holo6", __("Holo6 AI", "holo6") . " " . __("(admin)", "holo6"), "manage_options", "holo6-plugin", array("Holo6Pages", "render_plugin_settings_page_admin"));
        }
        else {
            $sub_menu_id = (version_compare(get_bloginfo("version"), "4.4", ">=")) ? 65 : 56387264;

            add_menu_page(
                __("Holo6", "holo6"),
                __("Holo6 AI", "holo6"),
                "manage_options",
                "holo6-settings-main",
                array("Holo6Pages", "render_plugin_settings_page_main"),
                "data:image/svg+xml;base64,PHN2ZyB4bWxucz0naHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmcnIGZpbGw9JyM5YWEwYTUnIHZpZXdCb3g9JzAgMCAyNCAyNCc+PHRpdGxlPnJvYm90LW91dGxpbmU8L3RpdGxlPjxwYXRoIGQ9J00xNy41IDE1LjVDMTcuNSAxNi42MSAxNi42MSAxNy41IDE1LjUgMTcuNVMxMy41IDE2LjYxIDEzLjUgMTUuNSAxNC40IDEzLjUgMTUuNSAxMy41IDE3LjUgMTQuNCAxNy41IDE1LjVNOC41IDEzLjVDNy40IDEzLjUgNi41IDE0LjQgNi41IDE1LjVTNy40IDE3LjUgOC41IDE3LjUgMTAuNSAxNi42MSAxMC41IDE1LjUgOS42MSAxMy41IDguNSAxMy41TTIzIDE1VjE4QzIzIDE4LjU1IDIyLjU1IDE5IDIyIDE5SDIxVjIwQzIxIDIxLjExIDIwLjExIDIyIDE5IDIySDVDMy45IDIyIDMgMjEuMTEgMyAyMFYxOUgyQzEuNDUgMTkgMSAxOC41NSAxIDE4VjE1QzEgMTQuNDUgMS40NSAxNCAyIDE0SDNDMyAxMC4xMyA2LjEzIDcgMTAgN0gxMVY1LjczQzEwLjQgNS4zOSAxMCA0Ljc0IDEwIDRDMTAgMi45IDEwLjkgMiAxMiAyUzE0IDIuOSAxNCA0QzE0IDQuNzQgMTMuNiA1LjM5IDEzIDUuNzNWN0gxNEMxNy44NyA3IDIxIDEwLjEzIDIxIDE0SDIyQzIyLjU1IDE0IDIzIDE0LjQ1IDIzIDE1TTIxIDE2SDE5VjE0QzE5IDExLjI0IDE2Ljc2IDkgMTQgOUgxMEM3LjI0IDkgNSAxMS4yNCA1IDE0VjE2SDNWMTdINVYyMEgxOVYxN0gyMVYxNlonIC8+PC9zdmc+",
                $sub_menu_id
            );

            // Si directement accessible dans le menu admin
            if (version_compare(get_bloginfo("version"), "5.3", ">=")) {
                // WP 5.3 a introduit le paramètre de position sur add_submenu_page
                add_submenu_page(
                    "holo6-settings-main",
                    __("Public assistant", "holo6"),
                    __("Public assistant", "holo6"),
                    "manage_options",
                    "holo6-settings-public",
                    array("Holo6Pages", "render_plugin_settings_page_public"),
                    $sub_menu_id+2
                );
                add_submenu_page(
                    "holo6-settings-main",
                    __("Writing helper", "holo6"),
                    __("Writing helper", "holo6"),
                    "manage_options",
                    "holo6-settings-admin",
                    array("Holo6Pages", "render_plugin_settings_page_admin"),
                    $sub_menu_id+3
                );
            }
            else {
                add_submenu_page(
                    "holo6-settings-main",
                    __("Public assistant", "holo6"),
                    __("Public assistant", "holo6"),
                    "manage_options",
                    "holo6-settings-public",
                    array("Holo6Pages", "render_plugin_settings_page_public")
                );
                add_submenu_page(
                    "holo6-settings-main",
                    __("Writing helper", "holo6"),
                    __("Writing helper", "holo6"),
                    "manage_options",
                    "holo6-settings-admin",
                    array("Holo6Pages", "render_plugin_settings_page_admin")
                );
            }
        }
    }

    public static function render_plugin_settings_page_main() {
        holo6_render_main_settings_page();
    }

    public static function render_plugin_settings_page_public() {
        self::_echo_config_html_tag("public");
    }

    public static function render_plugin_settings_page_admin() {
        self::_echo_config_html_tag("writer");
    }

    private static function _init_blocks_editor() {
        /* L'utilisation de la génération en ligne impose de s'assurer d'avoir les champs personnalisés dans l'éditeur Gutenberg. */
        add_filter('acf/settings/remove_wp_meta_box', '__return_false');  // ACF Display Custom Fields

        // Desactivation de Gutenberg ?!
        // // disable for posts
        // add_filter('use_block_editor_for_post', '__return_false', 10);

        // // disable for post types
        // add_filter('use_block_editor_for_post_type', '__return_false', 10);
    }

    protected static function _echo_config_html_tag($agent_role) {
        $client_settings = Holo6JSClientSettings::SelectSettingsCTOR($agent_role !== "public");
        $private_settings = new Holo6PrivateSettings();
        // $session_token = wp_generate_password(16, false, false);

        $session_token = get_site_option("holo6_last_session_token", null);
        if (is_string($session_token) && (strlen($session_token) > 0)) {
        }
        else {
            $session_token = wp_generate_password(16, false, false);
            update_site_option("holo6_last_session_token", $session_token);
        }
        echo("<div id=\"holo6_config_container\" style=\"margin: 8px 12px 0 0;\">");
        echo("\n<holo6_config-app");
        echo(" lang=\"auto\"");  // holo6_get_current_locale()
        echo(" site_id=\"" . holo6_get_current_site_name_format() . "\"");
        echo(" force_api_key=\"" . $private_settings->getFullAPIKey() . "\"");
        echo(" context_flags=\"embedded:" . $agent_role . "\"");
        echo(" csrf_token=\"" . $session_token . "\"");
        echo(" cfg_reference_file=\"" . $client_settings->get_holo6_conf_path_abs($agent_role) . "\"");
        echo(" cfg_reference_path=\"" . $client_settings->get_holo6_base_uri() . "\"");
        echo(" uploads_path=\"" . $client_settings->get_holo6_uploads_uri() . "\"");
        echo(" uploads_subdir=\"" . $client_settings->get_current_uploads_dir() . "\"");
        echo(" auth_path=\"" . $client_settings->get_auth_uri() . "\"");
        echo(" configuration_file_ui=\"" . $client_settings->get_holo6_conf_path_abs($agent_role) . "\"");
        echo(" configuration_file_cl=\"" . $client_settings->get_holo6_conf_path_abs("writer") . "\"");
        echo("></holo6_config-app>\n");
        echo("</div>");
    }
}

?>
