<?php

require_once constant("HOLO6_PLUGIN_DIR") . "plugin_pages/libs/utils.php";
// require_once constant("HOLO6_PLUGIN_DIR") . "plugin_pages/libs/holo6_avatar_config.php";
// require_once constant("HOLO6_PLUGIN_DIR") . "plugin_pages/libs/holo6_common_settings.php";
include_once constant("HOLO6_PLUGIN_DIR") . "holo6_js/config/uploads/holo6_config_upload_mod.php";


function Holo6ConfigEventsCallback($event_type_str, $file_path, $extra_data=null) {
    if ($event_type_str === "init_config") {
        // error_log("Holo6ConfigInitEventCallback (init_config : " . $file_path . ")");
        return true;
    }
    else if ($event_type_str === "recv_config") {
        return true;
    }
    else if ($event_type_str === "write_config") {
        // error_log("Holo6ConfigInitEventCallback (write_config : " . $file_path . ") : " . $extra_data);
        // error_log("Holo6ConfigInitEventCallback (write_config : " . $file_path . ")");
        if ($extra_data != null && strlen($extra_data) > 0) {
            $json_data = json_decode($extra_data, true);
            if ($json_data) {
                $core_config = $json_data["core"];
                if (array_key_exists("ui", $json_data["apps"])) {
                    $config_ui = $json_data["apps"]["ui"];
                    if ($core_config && $config_ui) {
                        $pos_sep = strpos($file_path, "/");
                        $nom_id_site = (($pos_sep !== false) && ($pos_sep > 0)) ? substr($file_path, 0, $pos_sep) : null;
                        $settings = new Holo6JSClientSettings($core_config["default_role"]);
                        $settings->set_app_enabled_option($core_config["enabled"], $nom_id_site);
                        $settings->set_ui_show_avatar_option($config_ui["show_avatar"], $nom_id_site);
                        $settings->set_ui_window_dockable_option($config_ui["window_dockable"], $nom_id_site);
                        // error_log("Assigne : enabled = " . ($settings->get_app_enabled_option() ? "oui" : "non"));
                        // error_log("Assigne : window dockable = " . ($settings->get_ui_window_dockable_option() ? "oui" : "non"));
                        return true;
                    }
                }
                if (array_key_exists("cl", $json_data["apps"])) {
                    $config_cl = $json_data["apps"]["cl"];
                    if ($core_config && $config_cl) {
                        return true;  /* typiquement summarizer */
                    }
                }
            }

        }
    }
    else if ($event_type_str === "recv_file") {
        if (substr($file_path, -4) === ".png") {
            return true;
        }
    }
    else if ($event_type_str === "write_file") {
        return true;
    }
    else if ($event_type_str === "remove_file") {
        if (substr($file_path, -4) === ".png") {
            return true;
        }
    }
    return false;
}

function Holo6ConfigWriteEventCallback($event_type_str, $file_path, $extra_data=null) {
    return Holo6ConfigEventsCallback($event_type_str, $file_path, $extra_data);
}


function Holo6ConfigInitEventCallback($event_type_str, $file_path, $extra_data=null) {
    return Holo6ConfigEventsCallback($event_type_str, $file_path, $extra_data);
}


class Holo6JSClientSettings {
    public $agent_role = null;
    protected $json_file_name = "";
    protected $config_uploads_path = "";
    protected $config_base_path = "";
    protected $config_root_fs = null;

    public function __construct($agent_role=null) {
        if ($agent_role === null) {
            if (holo6_is_current_admin()) {
                $this->agent_role = "writer";
            }
            else {
                $this->agent_role = "public";
            }
        }
        else {
                $this->agent_role = $agent_role;
        }

        $this->json_file_name = Holo6JSClientSettings::gen_config_filename($this->agent_role);
        $this->config_uploads_path = "config/uploads/";
        $this->config_base_path = "config/base/";
        $this->config_root_fs = constant("HOLO6_CLIENT_DIR") . "/" . $this->config_uploads_path;
    }

    public static function SelectSettingsCTOR($is_admin) {
        if ($is_admin) {
            return new Holo6JSClientSettings("writer");
        }
        else {
            return new Holo6JSClientSettings("public");
        }
    }

    public function getCurrentAgentRole() {
        return $this->agent_role;
    }

    public function isPublicAgent() {
        return $this->agent_role == "public";
    }

    public function injectPageContent() {
        return $this->isPublicAgent();
    }

    public function getPathUri() {
        return "/wp-content/plugins/wp-holo6/";
    }

    public function get_holo6_js_uri() {
        return $this->getPathUri() . "holo6_js/";
    }

    public function get_holo6_uploads_uri() {
        return $this->get_holo6_js_uri() . $this->config_uploads_path;
    }

    public function get_holo6_base_uri() {
        return $this->get_holo6_js_uri() . $this->config_base_path;
    }

    public function get_auth_uri() {
        return $this->get_holo6_js_uri() . "config/auth";
    }

    public function get_current_uploads_dir() {
        return holo6_get_current_site_name();
    }

    public static function gen_config_filename($nom_role) {
        $prefixe = "Holo6Config";
        // $suffixe = "@" . $_SERVER["SERVER_NAME"] . ".json";
        $suffixe = ".json";
        return $prefixe . "-" . $nom_role . $suffixe;
    }

    public function get_holo6_conf_path_abs($nom_role) {
        return $this->get_holo6_js_uri() . $this->get_holo6_conf_path($nom_role, false);
    }

//     public function settings_export_filename() {
//         return $this->json_file_name;
//     }

    public function get_holo6_conf_path($nom_role, $html_attribute=false) {
        $json_file_name = $this->config_uploads_path . $this->get_current_uploads_dir() . "/" . $this->gen_config_filename($nom_role);
        if ($html_attribute) {
            return rawurlencode($json_file_name) . "?ver=" . holo6_client_format_mtime_file($json_file_name);
        }
        return $json_file_name;
    }

    public function current_settings_file_path($html_attribute=false) {
        $json_file_name = $this->config_uploads_path . $this->get_current_uploads_dir() . "/" . $this->json_file_name;
        if ($html_attribute) {
            return rawurlencode($json_file_name) . "?ver=" . holo6_client_format_mtime_file($json_file_name);
        }
        return $json_file_name;
    }

    public static function settings_reference_path($force_current_network_id=null) {
        $base_path = constant("HOLO6_CLIENT_DIR") . "/" . $this->config_base_path;
        $current_locale = holo6_get_current_locale_installation($force_current_network_id);
        if (file_exists($base_path . "Holo6Config-base-" . $current_locale . ".json")) {
            return $base_path . "Holo6Config-base-" . $current_locale . ".json";
        }
        return $base_path . "Holo6Config-base-en.json";
    }

    public function get_file_data_site_id($current_network_id) {
        $json_file = $this->config_root_fs . holo6_get_site_name($current_network_id) . "/" . $this->json_file_name;
        if (file_exists($json_file)) {
            return file_get_contents($json_file);
        }
        return null;
    }

    public function get_app_enabled_option() {
        return $this->_get_option_generique_bool("holo6_app_enabled");
    }

    public function set_app_enabled_option($etat_bool, $site_name) {
        return $this->_set_option_generique_bool("holo6_app_enabled", $etat_bool, holo6_get_site_id_from_name($site_name));
    }

    public function set_ui_show_avatar_option($etat_bool, $site_name) {
        return $this->_set_option_generique_bool("holo6_ui_show_avatar", $etat_bool, holo6_get_site_id_from_name($site_name));
    }

    public function get_ui_show_avatar_option() {
        return $this->_get_option_generique_bool("holo6_ui_show_avatar");
    }

    public function get_ui_window_dockable_option() {
        return $this->_get_option_generique_bool("holo6_ui_window_dockable");
    }

    public function set_ui_window_dockable_option($etat_bool, $site_name) {
        return $this->_set_option_generique_bool("holo6_ui_window_dockable", $etat_bool, holo6_get_site_id_from_name($site_name));
    }
    
    public function get_app_enabled_main_site() {
        return $this->_get_option_generique_bool("holo6_app_enabled", Holo6CommonSettings::get_common_site_id());
    }

    public function json_file_exists_site_id($current_network_id) {
        $json_file = $this->config_root_fs . holo6_get_site_name($current_network_id) . "/" . $this->json_file_name;
        return file_exists($json_file);
    }

    public function export_settings_json($json_data, $force_current_network_id=null) {
        $current_network_id = ($force_current_network_id===null) ? holo6_current_site_id() : $force_current_network_id;

        $config_file_version = get_network_option($current_network_id, "holo6_config_file_version", 0);
        update_network_option($current_network_id, "holo6_config_file_version", ($config_file_version+1));

        $agent_role =  $this->getCurrentAgentRole();
        $uploads_instance = new Holo6ConfigManager("Holo6ConfigWriteEventCallback", null, null, false);
        if ($uploads_instance->write_agent_config($json_data, $agent_role, holo6_get_site_name($current_network_id), false)) {
            return true;
        }
        return false;
    }

    public function reset_default_settings($agent_role=null, $force_current_network_id=null) {
        $current_network_id = ($force_current_network_id===null) ? holo6_current_site_id() : $force_current_network_id;
        $dossier_config = $this->config_root_fs . holo6_get_site_name($current_network_id);

        $current_locale = holo6_get_current_locale_installation($force_current_network_id);
        $uploads_instance = new Holo6ConfigManager("Holo6ConfigInitEventCallback", null, null, false);
        if ($agent_role == null) {
            if ($uploads_instance->reset_default_agents_config($current_locale, holo6_get_site_name($current_network_id), false)) {
                return true;
            }
        }
        else {
            if ($uploads_instance->reset_config_from_base($current_locale, $agent_role, holo6_get_site_name($current_network_id), false)) {
                return true;
            }
        }
        return false;
    }

    private function _get_option_generique_bool($option_name, $force_current_network_id=null) {
        $current_network_id = ($force_current_network_id===null) ? holo6_current_site_id() : $force_current_network_id;
        $option_name_ext = $option_name . "-" . $this->getCurrentAgentRole();
        $v = get_network_option($current_network_id, $option_name_ext, null);
        
        // holo6_log("_get_option_generique_bool : " . $current_network_id . " : " .$option_name_ext . " : " . $v);

        if ($v === null) {
            return $v;
        }
        else if ($v === 1 or $v === "1") {
            return true;
        }
        else {
            return false;
        }
    }

    private function _set_option_generique_bool($option_name, $etat, $force_current_network_id=null) {
        $current_network_id = ($force_current_network_id===null) ? holo6_current_site_id() : $force_current_network_id;
        $option_name_ext = $option_name . "-" . $this->getCurrentAgentRole();

        // holo6_log("_set_option_generique_bool : " . $current_network_id . " : " .$option_name_ext . " : " . $etat);

        if ($etat === true or $etat === 1 or $etat === "1") {
            update_network_option($current_network_id, $option_name_ext, 1);
        }
        else if ($etat === false or $etat === 0 or $etat === "") {
            update_network_option($current_network_id, $option_name_ext, 0);
        }
        else {
            update_network_option($current_network_id, $option_name_ext, 1);
        }
    }

    private function _get_option_generique_int($option_name) {
        $current_network_id = holo6_current_site_id();
        $option_name_ext = $option_name . "-" . $this->getCurrentAgentRole();
        $v = get_network_option($current_network_id, $option_name_ext, null);
        if ($v === null) {
            return 0;
        }
        if (is_string($v)) {
            return intval($v);
        }
        return $v;
    }

    private function _set_option_generique_int($option_name, $etat, $force_current_network_id=null) {
        $current_network_id = ($force_current_network_id===null) ? holo6_current_site_id() : $force_current_network_id;
        $option_name_ext = $option_name . "-" . $this->getCurrentAgentRole();
        update_network_option($current_network_id, $option_name_ext, $etat);
    }
};
