<?php

require_once constant("HOLO6_PLUGIN_DIR") . "plugin_pages/libs/utils.php";


class Holo6CommonSettings {
    public function __construct() {
    }

    static public function get_common_site_id() {
        return 1;
    }

    public function get_PWA_URL() {
        $params_pwa_index = $this->get_mini_client_variant() ? "?h6_pwa_mini=1" :  "";
        return "https://" . $_SERVER["SERVER_NAME"] . "/wp-content/plugins/wp-holo6/PWA/index.php" . $params_pwa_index;
    }

    public function get_opensearch_enabled() { // Doit on activer l'injection de la description OpenSearch dans la page ?
        return $this->_get_value("opensearch", "0") === "1";
    }

    public function set_opensearch_state($state_bool) {
        $this->_set_value("opensearch", $state_bool ? "1" : "0");
    }

    public function get_pwa_enabled() { // Doit on activer l'injection de la description OpenSearch dans la page ?
        return $this->_get_value("pwa", "0") === "1";
    }

    public function set_pwa_state($state_bool) {
        $this->_set_value("pwa", $state_bool ? "1" : "0");
    }

    public function get_mini_client_variant() {
        return false;  // Force la valeur (pas totalement intégré).
        // return $this->_get_value("h6_mini_client", "0") === "1";
    }

    public function set_mini_client_variant($state_bool) {
        $this->_set_value("h6_mini_client", $state_bool ? "1" : "0");
    }

    // private function _delete_value($key) {
    //     return delete_network_option(self::get_common_site_id(), "holo6_common-".$key);
    // }

    private function _set_value(/*string*/ $key, $value) {
        return update_network_option(self::get_common_site_id(), "holo6_common-".$key, $value);
    }

    private function _get_value(/*string*/ $key, $default_value=null) {
        return get_network_option(self::get_common_site_id(), "holo6_common-".$key, $default_value);
    }
};

?>
