<?php

require_once constant("HOLO6_PLUGIN_DIR") . "plugin_pages/libs/utils.php";


class Holo6PrivateSettings { // Paramètres internes (en dehors de la configuration du client).
    private $current_network_id = 0;

    public function __construct($force_current_network_id=null) {
        $this->current_network_id = ($force_current_network_id===null) ? holo6_current_site_id() : $force_current_network_id;
    }

    public function getServerName() {
        $server_name = $_SERVER["SERVER_NAME"];
        if ($server_name === "_") {
            $server_name = "localhost";
        }
        return $server_name;
    }

    public function resetPasswords() {
        $this->_delete_value("api_key");
    }

    public function getAPIKey() {
        return $this->_get_value("api_key", "");
    }

    public function getFullAPIKey() {
        $stored_api_key = $this->getAPIKey();
        if (holo6_str_startsWith($stored_api_key, "pk:")) {
            return $stored_api_key;
        }
        else {
            return "pk:" . $this->getServerName() . ":" . $stored_api_key;
        }
    }

    public function APIKeyDefined() {
        return strlen($this->getAPIKey()) > 0;
    }

    public function setSecretAPIKey(/*string*/ $api_key) {
        // return $this->_set_value("api_key", holo6_esc_html(trim($api_key)));
        if (holo6_str_startsWith($api_key, "pk:")) {
            return $this->_set_value("api_key", holo6_esc_html(trim($api_key)));
        }
        else {
            return $this->_set_value("api_key", "pk:" . $this->getServerName() . ":" . holo6_esc_html(trim($api_key)));
        }
    }

    public function get_inline_config_api_key_html_param() {
        // return " api_key=\"" . $this->getFullAPIKey() . "\"";
        $stored_api_key = $this->getAPIKey();
        if (($stored_api_key != null) && (strlen($stored_api_key) > 0)) {
            $inline_config_encode = base64_encode("{\"core\":{\"client\":{\"api\":{\"global\":{\"key\":\"" . $stored_api_key . "\"}}}}}");
            return " configuration_inline=\"base64://" . $inline_config_encode . "\"";
        }
        else {
            return "";
        }
    }

    // public function getAPIServer() {
    //     return "https://adminapi.holo6.com" . "/";
    //     // return $this->_get_value("api_server", "https://adminapi.holo6.com") . "/";
    // }

    // public function setAPIServer(/*string*/ $api_server) {
    //     return $this->_set_value("api_server", esc_url(rtrim("https://adminapi.holo6.com", "/")));
    // }

    // public function setSearchDBPassword(/*string*/ $password) {
    //     return $this->_set_value("db_password", trim($password));
    // }

    public function getSearchDBPassword() {
        // return $this->_get_value("db_password", "");
        return "wp-oraclion";
    }

    private function _delete_value($key) {
        return delete_network_option($this->current_network_id, "holo6_private-".$key);
    }

    private function _set_value(/*string*/ $key, $value) {
        return update_network_option($this->current_network_id, "holo6_private-".$key, $value);
    }

    private function _get_value(/*string*/ $key, $default_value=null) {
        return get_network_option($this->current_network_id, "holo6_private-".$key, $default_value);
    }
};

?>