<?php

require_once constant("HOLO6_PLUGIN_DIR") . "plugin_pages/libs/utils.php";


class Holo6Notifications {
    /* Gère les notifications. */
    public function __construct() {
    }

    static public function echo_notification($message) {
        echo("<p><strong>");
        echo("[<a href=\"?page=holo6-settings-main\">" . __("Holo6", "holo6") . "</a>] " . esc_html($message));
        echo("</strong></p>");
    }

    public function haveNotifications() {
        return ($this->getNotificationsCount() > 0);
    }

    public function getNotificationsCount() {
        return count($this->getNotificationsListSuccess()) + count($this->getNotificationsListError());
    }

    public function getNotificationsListSuccess() {
        return get_network_option(holo6_current_site_id(), "holo6_notifications_success", array());
    }

    public function addNotificationSuccess($notification) {
        $notifications_list = $this->getNotificationsListSuccess();
        array_push($notifications_list, $notification);
        update_network_option(holo6_current_site_id(), "holo6_notifications_success", $notifications_list);
    }

    public function clearNotificationsSuccess() {
        delete_network_option(holo6_current_site_id(), "holo6_notifications_success");
    }

    public function getNotificationsListError() {
        return get_network_option(holo6_current_site_id(), "holo6_notifications_error", array());
    }

    public function addNotificationError($notification) {
        $notifications_list = $this->getNotificationsListError();
        array_push($notifications_list, $notification);
        update_network_option(holo6_current_site_id(), "holo6_notifications_error", $notifications_list);
    }

    public function clearNotificationsError() {
        delete_network_option(holo6_current_site_id(), "holo6_notifications_error");
    }

    public function getNotificationsListWarning() {
        return get_network_option(holo6_current_site_id(), "holo6_notifications_warning", array());
    }

    public function addNotificationWarning($notification) {
        $notifications_list = $this->getNotificationsListWarning();
        array_push($notifications_list, $notification);
        update_network_option(holo6_current_site_id(), "holo6_notifications_warning", $notifications_list);
    }

    public function clearNotificationsWarning() {
        delete_network_option(holo6_current_site_id(), "holo6_notifications_warning");
    }

    public function getNotificationsListInfo() {
        return get_network_option(holo6_current_site_id(), "holo6_notifications_info", array());
    }

    public function addNotificationInfo($notification) {
        $notifications_list = $this->getNotificationsListInfo();
        array_push($notifications_list, $notification);
        update_network_option(holo6_current_site_id(), "holo6_notifications_info", $notifications_list);
    }

    public function clearNotificationsInfo() {
        delete_network_option(holo6_current_site_id(), "holo6_notifications_info");
    }
};

function Holo6Notifications_from_POST() {
    /* Ajoute une notification depuis une commande POST (typiquement depuis javascript). */
    if (is_admin()) {
        if (isset($_POST["holo6_post_database_notification_type"])) {
            $translate_notification = ($_POST["holo6_post_database_notification_to_translate"] == "1");
            $message_notification = $translate_notification ? __($_POST["holo6_post_database_notification_message_start"], "holo6") : $_POST["holo6_post_database_notification_message_start"];
            if ($_POST["holo6_post_database_notification_message_middle"]) {
                $message_notification .=  $translate_notification ? __($_POST["holo6_post_database_notification_message_middle"], "holo6") : $_POST["holo6_post_database_notification_message_middle"];
            }
            if ($_POST["holo6_post_database_notification_message_end"]) {
                $message_notification .=  $translate_notification ? __($_POST["holo6_post_database_notification_message_end"], "holo6") : $_POST["holo6_post_database_notification_message_end"];
            }

            $notifications_manager = new Holo6Notifications();
            if ($_POST["holo6_post_database_notification_type"] == "error") {
                $notifications_manager->addNotificationError($message_notification);
            }
            else if ($_POST["holo6_post_database_notification_type"] == "warning") {
                $notifications_manager->addNotificationWarning($message_notification);
            }
            else if ($_POST["holo6_post_database_notification_type"] == "info") {
                $notifications_manager->addNotificationInfo($message_notification);
            }
            else if ($_POST["holo6_post_database_notification_type"] == "success") {
                $notifications_manager->addNotificationSuccess($message_notification);
            }
            do_action("admin_notices");
            return true;
        }
    }
    return false;
};

function Holo6Notifications_form_HTML($admin_page="main") {
    /* Créé le formuaire (invisible) pour poster une nofication depuis javascript. */
    if (is_admin()) {
        echo("<form style=\"display: none\" action=\"?page=holo6-settings-" . $admin_page . "\" method=\"POST\" id=\"holo6_post_database_notification\">");
        echo("<input type=\"hidden\" id=\"holo6_post_database_notification_type\" name=\"holo6_post_database_notification_type\" value=\"\"/>");
        echo("<input type=\"hidden\" id=\"holo6_post_database_notification_message_start\" name=\"holo6_post_database_notification_message_start\" value=\"\"/>");
        echo("<input type=\"hidden\" id=\"holo6_post_database_notification_message_middle\" name=\"holo6_post_database_notification_message_middle\" value=\"\"/>");
        echo("<input type=\"hidden\" id=\"holo6_post_database_notification_message_end\" name=\"holo6_post_database_notification_message_end\" value=\"\"/>");
        echo("<input type=\"hidden\" id=\"holo6_post_database_notification_to_translate\" name=\"holo6_post_database_notification_to_translate\" value=\"0\"/>");
        echo("</form>");
    }
}

function Holo6NotificationsRenderHTML() {
    /* Affiche les notifications. */
    $notifications_manager = new Holo6Notifications();
    $notifications_count = 0;

    $notifications_succes = $notifications_manager->getNotificationsListSuccess();
    if (empty($notifications_succes)) {
        ;
    }
    else {
        echo("<div class=\"notice notice-success settings-error is-dismissible\">");
        foreach ($notifications_succes as $message) {
            Holo6Notifications::echo_notification($message);
        }
        echo("</div>");
        $notifications_count += count($notifications_succes);
        $notifications_manager->clearNotificationsSuccess();
    }

    $notifications_errors = $notifications_manager->getNotificationsListError();
    if (empty($notifications_errors)) {
        ;
    }
    else {
        echo("<div class=\"notice notice-error settings-error is-dismissible\">");
        foreach ($notifications_errors as $message) {
            Holo6Notifications::echo_notification($message);
        }
        echo("</div>");
        $notifications_count += count($notifications_errors);
        $notifications_manager->clearNotificationsError();
    }

    $notifications_warning = $notifications_manager->getNotificationsListWarning();
    if (empty($notifications_warning)) {
        ;
    }
    else {
        echo("<div class=\"notice notice-warning settings-error is-dismissible\">");
        foreach ($notifications_warning as $message) {
            Holo6Notifications::echo_notification($message);
        }
        echo("</div>");
        $notifications_count += count($notifications_warning);
        $notifications_manager->clearNotificationsWarning();
    }

    $notifications_info = $notifications_manager->getNotificationsListInfo();
    if (empty($notifications_info)) {
        ;
    }
    else {
        echo("<div class=\"notice notice-info settings-error is-dismissible\">");
        foreach ($notifications_info as $message) {
            Holo6Notifications::echo_notification($message);
        }
        echo("</div>");
        $notifications_count += count($notifications_info);
        $notifications_manager->clearNotificationsInfo();
    }

    // if ($notifications_count > 0) {
    //     echo("<div class=\"notice notice-info settings-error is-dismissible\">");
    //     echo("<p>NOTIF !<p>");
    //     echo("</div>");
    // }
};

?>