<?php


function holo6_current_site_id() {
    return is_multisite() ? get_current_blog_id() : 1;
}

function holo6_get_current_locale_installation($force_current_network_id=null) {
    // $current_network_id = ($force_current_network_id===null) ? holo6_current_site_id() : $force_current_network_id;
    if (is_multisite() && ($force_current_network_id !== null)) {
        switch_to_blog($force_current_network_id);
        $ms_locale = get_option("WPLANG");
        restore_current_blog();
        // holo6_log("TEST LANG (" . $force_current_network_id . ") : " . $ms_locale);
        return explode("_", $ms_locale)[0];
    }
    else {
        return explode("_", get_locale())[0];
    }

}

function holo6_get_current_locale($force_current_network_id=null) {
    // $current_network_id = ($force_current_network_id===null) ? holo6_current_site_id() : $force_current_network_id;
    if (is_multisite() && ($force_current_network_id !== null)) {
        $ms_locale = get_network_option($force_current_network_id, "WPLANG", "en_US");
        return explode("_", $ms_locale)[0];
    }
    else {
        if ( defined("WPLANG") ) {
            return explode("_", constant("WPLANG"))[0];
        }
        else {
            // return explode("_", get_site_option("WPLANG", "en_US"))[0];
            return explode("_", get_locale())[0];
        }
    }
}

function holo6_get_site_name($site_id) {
    if ($site_id <= 1 ) {
        return strval($site_id);
    }
    if (is_multisite()) {
        if (function_exists("get_site")) {
            $details = get_site($site_id);
            $v_url = $details->siteurl;
            if (strlen($v_url) > 0) {
                $path = parse_url($v_url, PHP_URL_PATH);
                if ($path) {
                    return substr($path, 1, strlen($path));
                }
            }
            return $details->blogname;
        }
        else {
            return strval($site_id);
        }
    }
    $v_url = get_bloginfo("url");
    if (strlen($v_url) > 0) {
        $path = parse_url($v_url, PHP_URL_PATH);
        if ($path) {
            return substr($path, 1, strlen($path));
        }
    }
    return get_bloginfo("name");
}

function holo6_get_current_site_name() {
    $site_id = holo6_current_site_id();
    return holo6_get_site_name($site_id);
}

function holo6_get_current_site_name_format() {
    return str_replace("-", "_", str_replace(" ", "_", holo6_get_current_site_name()));
}

function holo6_current_site_title_name($ignore_notice_main_site_bool=false) {
    if (is_multisite()) {
        // return get_home_url(holo6_current_site_id());
        if (!$ignore_notice_main_site_bool && is_main_site(get_current_blog_id())) {
            // return $_SERVER["SERVER_NAME"] . " / " . get_bloginfo("name") . " " . __("(API reference)", "holo6");
            return get_bloginfo("name") . " " . __("(main site / API reference)", "holo6");
        }
        else {
            // return $_SERVER["SERVER_NAME"] . " / " . get_bloginfo("name");
            return get_bloginfo("name");
        }
    }
    else {
        return $_SERVER["SERVER_NAME"];
    }
}

function holo6_get_sites_count() {
    if (is_multisite()) {
        if (function_exists("get_sites")) { // A partir de Wordpress 4.6
            return get_sites(array("count" => true));
        }
        else if (function_exists("wp_get_sites")) { // A partir de Wordpress 3.7
            return sizeof(wp_get_sites(array("network_id" => null)));
        }
    }
    return 1;
}

function holo6_get_sites_id_list() {
    if (is_multisite()) {
        if (function_exists("get_sites")) { // A partir de Wordpress 4.6
            $sites = get_sites(array("fields" => "ids"));
            return $sites;
        }
        else if (function_exists("wp_get_sites")) { // A partir de Wordpress 3.7
            $liste_sites = wp_get_sites(array("network_id" => null));
            $liste_r = array();
            foreach ( $liste_sites as $site ) {
                array_push($liste_r, $site["site_id"]);
            }
            return $liste_r;
        }
    }
    return array(1);
}

function holo6_get_site_id_from_name($site_name) {
    if (is_multisite()) {
        $liste_sites = holo6_get_sites_id_list();
        foreach ( $liste_sites as $site_id ) {
            if (holo6_get_site_name($site_id) == $site_name) {
                return $site_id;
            }
        }
    }
    else {
        return 1;
    }
    return null;
}

function holo6_client_format_mtime_file($filename) {
    $file_path = constant("HOLO6_CLIENT_DIR") . $filename;
    if (file_exists($file_path)) {
        return date("dmy-Gis", filemtime($file_path));
    }
    return -1;
}

function holo6_plugin_format_mtime_file($filename) {
    $file_path = constant("HOLO6_PLUGIN_DIR") . $filename;
    if (file_exists($file_path)) {
        return date("dmy-Gis", filemtime($file_path));
    }
    return -1;
}

function holo6_is_current_admin() {
    if (is_admin()) {
        $current_page = $_SERVER["REQUEST_URI"];
        return (strpos($current_page, "/wp-admin/") !== false);
    }
    return false;
}

function holo6_encodeURIComponent($str) {
    $revert = array('%21'=>'!', '%2A'=>'*', '%27'=>"'", '%28'=>'(', '%29'=>')');
    return strtr(rawurlencode($str), $revert);
}

function holo6_current_serveur_public_key() {
    return ("pk:" . $_SERVER["SERVER_NAME"]);
}

function holo6_official_website_url($lang) {
    $connexion_arg = "?oraclion_user_login=" . holo6_encodeURIComponent(holo6_current_serveur_public_key());
    if ($lang === "fr") {
        return "https://holo6.com/fr/compte/" . $connexion_arg;
    }
    else {
        return "https://holo6.com/en/log-in/" . $connexion_arg;
    }
}

function holo6_debug($message) { // Affiche à l'écran
    if (WP_DEBUG === true) {
        if (! empty($message)) {
            echo("<span class='debug'><b>[holo6]</b> ");
            if (is_array($message) || is_object($message)) {
                echo("<pre>");
                print_r($message);
                echo("</pre>");
            }
            else {
                echo($message);
            }
            echo("</span>");
        }
    }
}

// function holo6_fusion_dicts($source, $dest) {
//     $dest = array_replace_recursive($dest, $source);
//     return $dest;
// }

function holo6_esc_html($texte) {
    return (function_exists("esc_textarea") ? esc_textarea($texte) : esc_html($texte)); // Pour la compatibilité
}

function holo6_log_backtrace() {
    $liste_backtrace = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS);  // PHP >= 5.3.6
    $nombre_trace = count($liste_backtrace);
    error_log("[holo6][traceback] :");
    error_log("{");
    for ($id=0; $id<$nombre_trace ; $id++) {
        $index_trace = count($liste_backtrace) - $id;
        $index_trace_str = (count($liste_backtrace) >= 10) ? (($index_trace) >= 10 ? strval($index_trace) : (" " . strval($index_trace))) : strval($index_trace);
        $trace = $liste_backtrace[$id];
        if (array_key_exists("class", $trace)) {
            error_log("    [" . $index_trace_str . "] " . sprintf("%s:%s (%s::%s())", $trace["file"], $trace["line"], $trace["class"], $trace["function"]));
        }
        else {
            error_log("    [" . $index_trace_str . "] " . sprintf("%s:%s (%s())", $trace["file"], $trace["line"], $trace["function"]));
        }
    }
    error_log("}");
}

function holo6_log($message, $print_backtrace=false) { // Envoi dans le journal
    if (WP_DEBUG === true) {
        if (is_array($message) || is_object($message)) {
            error_log("[holo6] : '" . print_r($message, true) . "'");
        }
        else {
            error_log("[holo6] : '" . $message . "'");
        }
        if ($print_backtrace) {
            holo6_log_backtrace(1);  // Passe le premier élément, qui est cet appel.
        }
    }
}

function holo6_str_startsWith($haystack, $needle) { // Equivalent à str_starts_with (cette dernière fonction requiert PHP 8)
    return substr($haystack, 0, strlen($needle)) === $needle;
}

function holo6_str_endsWith($haystack, $needle) { // Equivalent à str_ends_with (cette dernière fonction requiert PHP 8)
   $needle_len = strlen($needle);
   if (!$needle_len) {
       return true;
   }
   return substr($haystack, -$needle_len) === $needle;
}

?>
