<?php

require_once constant("HOLO6_PLUGIN_DIR") . "plugin_pages/libs/utils.php";
require_once constant("HOLO6_PLUGIN_DIR") . "plugin_pages/libs/holo6_common_settings.php";
require_once constant("HOLO6_PLUGIN_DIR") . "plugin_pages/libs/holo6_client_settings.php";
require_once constant("HOLO6_PLUGIN_DIR") . "plugin_pages/main_settings/main_settings_post.php";

function holo6_render_main_settings_main_page() {
    if (holo6_main_update_config_post()) {
    }
    
    // $current_network_id = holo6_current_site_id();
    $common_settings = new Holo6CommonSettings();
    $public_ai_settings = Holo6JSClientSettings::SelectSettingsCTOR(false);

    echo("<div class=\"wrap holo6_base\">");
    echo("<h1 class=\"wp-heading-inline\" style=\"\">" . sprintf(__("Holo6 AI Settings on %s", "holo6"), "<span class=\"holo6_surligne_titre\">" . holo6_current_site_title_name(false) . "</span>") . "</h1>");
    echo("<hr class=\"wp-header-end\"><br>");

    echo("<h3 style=\"\">" . __("Welcome to the Holo6 AI configuration page", "holo6") . "</h3>");
    echo("<div style=\"margin-left: 2em; font-size: 14px;\">");
        echo("<span>" . esc_attr__("Holo6 AI allows you to integrate a conversational agent into your website to assist you in writing your articles, but also to assist your website visitors.", "holo6") . "<br></span>");
        echo("<span>" . esc_attr__("To be able to provide this service publicly to your users, your domain name must be registered to Holo6 Services.", "holo6") . "<br></span>");
    echo("<p><h4>" . (sprintf(__("Some parameters related to your client account must be done via the <a href=\"%s\">Holo6 website</a>", "holo6"), holo6_official_website_url(holo6_get_current_locale()))) . "</h4></p>");
    echo("<p><h4>" . __("Go to AI settings:", "holo6"));
    echo("<span style=\"display: inline; margin-left: 0.5em;\"><a href=\"?page=holo6-settings-public\">" . __("Public AI", "holo6") . "</a>&nbsp;/&nbsp;<a href=\"?page=holo6-settings-admin\">" . __("Admin AI", "holo6") . "</a></span>");
    echo("</h4></p></div>");

    echo("<div style=\"margin-top: 32px; font-size: 14px;\">");
        echo("<h3 style=\"\">" . __("Website settings", "holo6") . "</h3>");
            if (holo6_get_sites_count() > 1 && holo6_current_site_id() !== 1) {
                // if ($public_ai_settings->get_app_enabled_main_site() === true) {
                    echo("<div style=\"margin-left: 2em; margin-bottom: 2em; border: 2px solid #ff5555; padding: 8px; width: fit-content; border-radius: 4px;\">");
                        echo("<div>" . __("It appears that there are multiple sites on this server.", "holo6") . "</div>");
                        echo("<div>" . __("Please note that only the main site settings will be used for PWA and OpenSearch.", "holo6") . "</div>");
                        echo("<div style=\"margin-top: 8px;\"><a href=\"" . get_admin_url(1) . "admin.php?page=holo6-settings-main\">" . __("Go to main site settings", "holo6") . "</a></div>");
                    echo("</div>");
                // }
            }
            else {
                echo("<table class=\"widefat striped holo6_table\" role=\"presentation\" style=\"width: fit-content;\">");
                    echo("<form action=\"\" method=\"post\">");
                        echo("<tr><td scope=\"row\" style=\"max-width: 50em;\">");
                        echo("<div style=\"padding: 8px;\">");
                            echo("<div>");
                                if ($public_ai_settings->get_app_enabled_main_site() === true) {
                                    if ($common_settings->get_pwa_enabled() === true) {
                                        echo("<input type=\"hidden\" id=\"holo6_desactive_pwa\" name=\"holo6_desactive_pwa\" value=\"1\"/>");
                                        echo("<input type=\"submit\" class=\"button button-secondary\" value=\"" . esc_attr__("Disable PWA", "holo6") . "\" name=\"holo6_pwa\" />");
                                    }
                                    else {
                                        echo("<input type=\"hidden\" id=\"holo6_active_pwa\" name=\"holo6_active_pwa\" value=\"1\"/>");
                                        echo("<input type=\"submit\" class=\"button button-primary\" value=\"" . esc_attr__("Activate PWA", "holo6") . "\" name=\"holo6_pwa\" />");
                                    }
                                }
                                else {
                                    echo("<div style=\"padding: 4px; margin: 4px 0px; border: 2px solid red; border-radius: 4px; width: fit-content;\">" . sprintf(__("You must enable the <a href=\"%s\">public AI</a> to enable PWA", "holo6"), admin_url() . "admin.php?page=holo6-settings-public") . "</div>");
                                }

                            echo("</div>");
                            echo("<span>" . __("PWA (Progressive Web App) allows you to declare the AI chat application on the user browser. However, it can cause conflicts if you're already using this technology on this site.", "holo6") . "</span>");
                        echo("</div>");
                        echo("</td></tr>");
                    echo("</form>");

                    echo("<form action=\"\" method=\"post\">");
                        echo("<tr><td scope=\"row\" style=\"max-width: 50em;\">");
                        echo("<div style=\"padding: 8px;\">");
                            echo("<div>");
                                if ($public_ai_settings->get_app_enabled_main_site() === true) {
                                    if ($common_settings->get_opensearch_enabled() === true) {
                                        echo("<input type=\"hidden\" id=\"holo6_desactive_opensearch\" name=\"holo6_desactive_opensearch\" value=\"1\"/>");
                                        echo("<input type=\"submit\" class=\"button button-secondary\" value=\"" . esc_attr__("Disable OpenSearch", "holo6") . "\" name=\"holo6_opensearch\" />");
                                    }
                                    else {
                                        echo("<input type=\"hidden\" id=\"holo6_active_opensearch\" name=\"holo6_active_opensearch\" value=\"1\"/>");
                                        echo("<input type=\"submit\" class=\"button button-primary\" value=\"" . esc_attr__("Activate OpenSearch", "holo6") . "\" name=\"holo6_opensearch\" />");
                                    }
                                }
                                else {
                                    echo("<div style=\"padding: 4px; margin: 4px 0px; border: 2px solid red; border-radius: 4px; width: fit-content;\">" . sprintf(__("You must enable the <a href=\"%s\">public AI</a> to enable OpenSearch", "holo6"), admin_url() . "admin.php?page=holo6-settings-public") . "</div>");
                                }
                            echo("</div>");
                            echo("<span>" . __("OpenSearch is a search engine declaration standard. It enables integration of your AI into the search bars of browsers that support it.", "holo6") . "</span>");

                            if (holo6_get_sites_count() > 1) {
                                echo("<br><div style=\"margin-top: 1em;\">" . __("It appears that there are multiple sites on this server. Note that on Chrome and Chrome-based browsers, the OpenSearch declaration only works on the root page, typically the main site's homepage.", "holo6") . "</div>");
                            }
                        echo("</div></td></tr>");
                    echo("</form>");
                echo("</table>");
            }            
            echo("<div style=\"margin-left: 2em; margin-top: 16px;\">");
                echo("<span>" . __("Your public AI QR Code", "holo6"));
                    if ($public_ai_settings->get_app_enabled_main_site() === true) {
                    }
                    else {
                        echo("<span style=\"margin-left: 4px; border: 2px solid red; padding: 4px; border-radius: 4px;\"><a href=\"" . get_admin_url(1) . "admin.php?page=holo6-settings-public\">" . __("The public AI must be enabled", "holo6") . "</a></span>");
                    }
                    echo("</span>");
                    echo("<div style=\"padding: 0px; margin-top: 8px; background-color: white; width: 276px; height: 276px;\"><a href=\"" . $common_settings->get_PWA_URL() . "\"><div id=\"holo6-pwa_qrcode\" style=\"width: 256px; height: 256px; padding-left: 10px; padding-top: 10px;\"></div></a></div>");
            echo("</div>");
        echo("</div>");
    echo("</div>");
}

function holo6_render_main_settings_page() {
    if (is_admin()) {
        Holo6Notifications_from_POST();
        Holo6Notifications_form_HTML("main");
        holo6_render_main_settings_main_page();
    }
}

?>