<?php

require_once constant("HOLO6_PLUGIN_DIR") . "plugin_pages/libs/utils.php";
require_once constant("HOLO6_PLUGIN_DIR") . "plugin_pages/libs/notifications.php";
require_once constant("HOLO6_PLUGIN_DIR") . "plugin_pages/libs/holo6_common_settings.php";


function holo6_main_update_config_post() {
    if (! is_admin()) {
        ;
    }
    else if ($_SERVER["REQUEST_METHOD"] == "POST") {
        $common_settings = new Holo6CommonSettings();
        $notifications_manager = new Holo6Notifications();
        if (isset($_POST["holo6_active_pwa"])) {
            $common_settings->set_pwa_state(true);
            $notifications_manager->addNotificationSuccess(__("PWA enabled", "holo6"));
        }
        else if (isset($_POST["holo6_desactive_pwa"])) {
            $common_settings->set_pwa_state(false);
            $notifications_manager->addNotificationSuccess(__("PWA disabled", "holo6"));
        }
        else if (isset($_POST["holo6_active_opensearch"])) {
            $common_settings->set_opensearch_state(true);
            $notifications_manager->addNotificationSuccess(__("OpenSearch enabled", "holo6"));
        }
        else if (isset($_POST["holo6_desactive_opensearch"])) {
            $common_settings->set_opensearch_state(false);
            $notifications_manager->addNotificationSuccess(__("OpenSearch disabled", "holo6"));
        }
        do_action("admin_notices");
        return true;
    }
    return false;
}


?>