<?php

/* Appelé implicitement par Wordpress uniquement lors de la désinstallation... */


function holo6_delete_option_settings($current_network_id, $nom_opt) {
    delete_network_option($current_network_id, $nom_opt . "-public");
    delete_network_option($current_network_id, $nom_opt . "-writer");
    delete_network_option($current_network_id, $nom_opt . "-summarizer");
}

// if uninstall.php is not called by WordPress, die
if (! defined("WP_UNINSTALL_PLUGIN") ) {
    die;
}
else {
    require_once __DIR__ . "/plugin_pages/libs/utils.php";

    $sites_id = holo6_get_sites_id_list();
    foreach ( $sites_id as $current_network_id ) {
        // delete_network_option($current_network_id, "oraclion_achats_delai_validite_nvx");
        
        delete_network_option($current_network_id, "holo6_notifications_success");
        delete_network_option($current_network_id, "holo6_notifications_error");
        delete_network_option($current_network_id, "holo6_config_file_version");

        /* Voir Holo6JSClientSettings */
        holo6_delete_option_settings($current_network_id, "holo6_ui_show_avatar");
        holo6_delete_option_settings($current_network_id, "holo6_ui_window_dockable");
        // holo6_delete_option_settings($current_network_id, "holo6_ui_notification_type_after_response");
        holo6_delete_option_settings($current_network_id, "holo6_app_enabled");

        /* Voir Holo6PrivateSettings */
        // delete_network_option($current_network_id, "holo6_private-api_server");
        delete_network_option($current_network_id, "holo6_private-api_key");
        // delete_network_option($current_network_id, "holo6_private-db_password");

        /* Voir Holo6CommonSettings */
        delete_network_option($current_network_id, "holo6_common-pwa");
        delete_network_option($current_network_id, "holo6_common-opensearch");
    
        delete_network_option($current_network_id, "holo6_public_settings_data"); // Au cas où...
        delete_network_option($current_network_id, "holo6_writer_settings_data"); // Au cas où...
    }

    delete_site_option("holo6_last_session_token");
    delete_site_option("holo6_plugin_state");
    delete_site_option("holo6_plugin_installed_version");
}

?>